<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-04-02 16:06:32
 */
namespace Mainto\Bridge\Invokes\BscFinanceCost;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class DataHandle
 * @method taskCostNonOperatingByParams(array $params) 同步金蝶非经成本
 * @method retrySyncSplitMonthByParams(array $params) 重新同步:成本分配
 * @method taskCostSplitMonthByParams(array $params) 同步金蝶生产成本
 * @method batchSyncNonOperatingByParams(array $params) 全量同步:非经成本
 * @method nonOperatingSyncPageListByParams(array $params) 非经成本同步金蝶分页列表
 * @method batchSyncSplitMonthByParams(array $params) 全量同步:成本分配
 * @method taskAccruedChargeTeamBuildingByParams(array $params) 同步金蝶团建费用
 * @method taskAccruedChargeCloudPhotoByParams(array $params) 同步金蝶云图费用
 * @method retrySyncNonOperatingByParams(array $params) 重新同步:非经成本
 * @method splitMonthSyncPageListByParams(array $params) 成本分配同步金蝶分页列表
 */
class DataHandle {
    private static string $serviceName = "BscFinanceCost";

    private static string $className = "DataHandle";

    /**
     * 同步金蝶非经成本
     * @return  bool
    */
    public static function taskCostNonOperating () {
        return RpcClass::getClass(self::$serviceName, self::$className)->taskCostNonOperating();
    }

    /**
     * 重新同步:成本分配
     * @return  bool
    */
    public static function retrySyncSplitMonth (?\Mainto\Bridge\Structs\BscFinanceCost\Com\Mainto\Finance\Cost\Allocation\Biz\Params\IdParam $idParam = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->retrySyncSplitMonth($idParam);
    }

    /**
     * 同步金蝶生产成本
     * @return  bool
    */
    public static function taskCostSplitMonth () {
        return RpcClass::getClass(self::$serviceName, self::$className)->taskCostSplitMonth();
    }

    /**
     * 全量同步:非经成本
     * @return  bool
    */
    public static function batchSyncNonOperating (?\Mainto\Bridge\Structs\BscFinanceCost\Com\Mainto\Finance\Cost\Allocation\Biz\Params\DataBeachSyncParam $dataBeachSyncParam = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchSyncNonOperating($dataBeachSyncParam);
    }

    /**
     * 非经成本同步金蝶分页列表
     * @return  \Mainto\Bridge\Structs\BscFinanceCost\Com\Mainto\Finance\Cost\Allocation\Biz\Res\NonOperatingHeaderPageListDTO
    */
    public static function nonOperatingSyncPageList (?\Mainto\Bridge\Structs\BscFinanceCost\Com\Mainto\Finance\Cost\Allocation\Biz\Params\DataHandlePageListParam $dataHandlePageListParam = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->nonOperatingSyncPageList($dataHandlePageListParam),
            "\Mainto\Bridge\Structs\BscFinanceCost\Com\Mainto\Finance\Cost\Allocation\Biz\Res\NonOperatingHeaderPageListDTO"
        );
    }

    /**
     * 全量同步:成本分配
     * @return  bool
    */
    public static function batchSyncSplitMonth (?\Mainto\Bridge\Structs\BscFinanceCost\Com\Mainto\Finance\Cost\Allocation\Biz\Params\DataBeachSyncParam $dataBeachSyncParam = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchSyncSplitMonth($dataBeachSyncParam);
    }

    /**
     * 同步金蝶团建费用
     * @return  bool
    */
    public static function taskAccruedChargeTeamBuilding () {
        return RpcClass::getClass(self::$serviceName, self::$className)->taskAccruedChargeTeamBuilding();
    }

    /**
     * 同步金蝶云图费用
     * @return  bool
    */
    public static function taskAccruedChargeCloudPhoto () {
        return RpcClass::getClass(self::$serviceName, self::$className)->taskAccruedChargeCloudPhoto();
    }

    /**
     * 重新同步:非经成本
     * @return  bool
    */
    public static function retrySyncNonOperating (?\Mainto\Bridge\Structs\BscFinanceCost\Com\Mainto\Finance\Cost\Allocation\Biz\Params\IdParam $idParam = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->retrySyncNonOperating($idParam);
    }

    /**
     * 成本分配同步金蝶分页列表
     * @return  \Mainto\Bridge\Structs\BscFinanceCost\Com\Mainto\Finance\Cost\Allocation\Biz\Res\SplitMonthHeaderPageListDTO
    */
    public static function splitMonthSyncPageList (?\Mainto\Bridge\Structs\BscFinanceCost\Com\Mainto\Finance\Cost\Allocation\Biz\Params\DataHandlePageListParam $dataHandlePageListParam = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->splitMonthSyncPageList($dataHandlePageListParam),
            "\Mainto\Bridge\Structs\BscFinanceCost\Com\Mainto\Finance\Cost\Allocation\Biz\Res\SplitMonthHeaderPageListDTO"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}