<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-01-03 16:25:20
 */
namespace Mainto\Bridge\Invokes\BscFinanceCorpPayment\Com\Mainto\Finance\Corp\Payment\Admin\Controller;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class IPaymentTransferController
 * @method getItemListByParams(array $params) 子单详情列表
 * @method submitByParams(array $params) 提交付款
 * @method getKingdeeProjectTypeSelectorByParams(array $params) 金蝶组织列表
 * @method payBackByParams(array $params) 支付回调
 * @method callBackByParams(array $params) 审批回调
 * @method updateByParams(array $params) 资金调拨单更新
 * @method revokeByParams(array $params) 撤回审批
 * @method autoCreateByParams(array $params) 下拨调拨单自动创建
 * @method getPageListByParams(array $params) 分页列表
 * @method autoUpCreateByParams(array $params) 上划调拨单自动创建
 * @method createByParams(array $params) 资金调拨单创建
 * @method detailByParams(array $params) 单据详情
 * @method syncKingdeeByParams(array $params) 金蝶重推
 */
class IPaymentTransferController {
    private static string $serviceName = "BscFinanceCorpPayment";

    private static string $className = "com.mainto.finance.corp.payment.admin.controller.IPaymentTransferController";

    /**
     * 子单详情列表
     * @return  array
    */
    public static function getItemList (?\Mainto\Bridge\Structs\BscFinanceCorpPayment\Com\Mainto\Finance\Model\Req\TransferItemSearchAppReq $transferItemSearchAppReq = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getItemList($transferItemSearchAppReq),
            "\Mainto\Bridge\Structs\BscFinanceCorpPayment\Com\Mainto\Finance\Model\Resp\PaymentTransferItemRes[]"
        );
    }

    /**
     * 提交付款
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\BscFinanceCorpPayment\Com\Mainto\Finance\Model\Resp\PaymentTransferRes
    */
    public static function submit () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->submit([]),
            "\Mainto\Bridge\Structs\BscFinanceCorpPayment\Com\Mainto\Finance\Model\Resp\PaymentTransferRes"
        );
    }

    /**
     * 金蝶组织列表
     * @return  array
    */
    public static function getKingdeeProjectTypeSelector () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getKingdeeProjectTypeSelector(),
            "\Mainto\Bridge\Structs\BscFinanceCorpPayment\Com\Mainto\Finance\Model\Resp\KingdeeProjectTypeRes[]"
        );
    }

    /**
     * 支付回调
     * @return  string
    */
    public static function payBack (?\Mainto\Bridge\Structs\BscFinanceCorpPayment\Com\Mainto\Finance\Model\Resp\PaymentRequestRecordsMessageRes $paymentRequestRecordsMessageRes = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->payBack($paymentRequestRecordsMessageRes);
    }

    /**
     * 审批回调
     * @return  string
    */
    public static function callBack (?\Mainto\Bridge\Structs\BscFinanceCorpPayment\Com\Mainto\Finance\Model\Req\DingCallBackAppReq $dingCallBackAppReq = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->callBack($dingCallBackAppReq);
    }

    /**
     * 资金调拨单更新
     * @return  \Mainto\Bridge\Structs\BscFinanceCorpPayment\Com\Mainto\Finance\Model\Resp\PaymentTransferRes
    */
    public static function update (?\Mainto\Bridge\Structs\BscFinanceCorpPayment\Com\Mainto\Finance\Model\Req\TransferUpdateAppReq $transferUpdateAppReq = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->update($transferUpdateAppReq),
            "\Mainto\Bridge\Structs\BscFinanceCorpPayment\Com\Mainto\Finance\Model\Resp\PaymentTransferRes"
        );
    }

    /**
     * 撤回审批
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\BscFinanceCorpPayment\Com\Mainto\Finance\Model\Resp\PaymentTransferRes
    */
    public static function revoke () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->revoke([]),
            "\Mainto\Bridge\Structs\BscFinanceCorpPayment\Com\Mainto\Finance\Model\Resp\PaymentTransferRes"
        );
    }

    /**
     * 下拨调拨单自动创建
     * @return  string
    */
    public static function autoCreate () {
        return RpcClass::getClass(self::$serviceName, self::$className)->autoCreate();
    }

    /**
     * 分页列表
     * @return  \Mainto\Bridge\Structs\BscFinanceCorpPayment\Com\Mainto\Supply\Tools\Common\PageList
    */
    public static function getPageList (?\Mainto\Bridge\Structs\BscFinanceCorpPayment\Com\Mainto\Finance\Model\Req\TransferSearchAppReq $transferSearchAppReq = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getPageList($transferSearchAppReq),
            "\Mainto\Bridge\Structs\BscFinanceCorpPayment\Com\Mainto\Supply\Tools\Common\PageList"
        );
    }

    /**
     * 上划调拨单自动创建
     * @return  bool
    */
    public static function autoUpCreate () {
        return RpcClass::getClass(self::$serviceName, self::$className)->autoUpCreate();
    }

    /**
     * 资金调拨单创建
     * @return  \Mainto\Bridge\Structs\BscFinanceCorpPayment\Com\Mainto\Finance\Model\Resp\PaymentTransferRes
    */
    public static function create (?\Mainto\Bridge\Structs\BscFinanceCorpPayment\Com\Mainto\Finance\Model\Req\TransferCreateAppReq $transferCreateAppReq = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->create($transferCreateAppReq),
            "\Mainto\Bridge\Structs\BscFinanceCorpPayment\Com\Mainto\Finance\Model\Resp\PaymentTransferRes"
        );
    }

    /**
     * 单据详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\BscFinanceCorpPayment\Com\Mainto\Finance\Model\Resp\PaymentTransferRes
    */
    public static function detail () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->detail([]),
            "\Mainto\Bridge\Structs\BscFinanceCorpPayment\Com\Mainto\Finance\Model\Resp\PaymentTransferRes"
        );
    }

    /**
     * 金蝶重推
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  string
    */
    public static function syncKingdee () {
        return RpcClass::getClass(self::$serviceName, self::$className)->syncKingdee([]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}