<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-03-13 22:07:16
 */
namespace Mainto\Bridge\Invokes\BscFinanceBasic;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class DataHandleController
 * @method taskSyncDepartmentByParams(array $params) 同步核算部门到金蝶
 * @method taskSyncBankBranchByParams(array $params) 同步银行支行到金蝶
 * @method taskSyncBankCardByParams(array $params) 同步银行卡号到金蝶
 * @method taskAllocateDepartmentByParams(array $params) 核算部门分配组织
 * @method taskSyncDepartmentAwsByParams(array $params) 同步核算部门信息到炎黄
 */
class DataHandleController {
    private static string $serviceName = "BscFinanceBasic";

    private static string $className = "DataHandleController";

    /**
     * 同步核算部门到金蝶
     * @return  bool
    */
    public static function taskSyncDepartment () {
        return RpcClass::getClass(self::$serviceName, self::$className)->taskSyncDepartment();
    }

    /**
     * 同步银行支行到金蝶
     * @return  bool
    */
    public static function taskSyncBankBranch () {
        return RpcClass::getClass(self::$serviceName, self::$className)->taskSyncBankBranch();
    }

    /**
     * 同步银行卡号到金蝶
     * @return  bool
    */
    public static function taskSyncBankCard () {
        return RpcClass::getClass(self::$serviceName, self::$className)->taskSyncBankCard();
    }

    /**
     * 核算部门分配组织
     * @return  bool
    */
    public static function taskAllocateDepartment () {
        return RpcClass::getClass(self::$serviceName, self::$className)->taskAllocateDepartment();
    }

    /**
     * 同步核算部门信息到炎黄
     * @return  bool
    */
    public static function taskSyncDepartmentAws () {
        return RpcClass::getClass(self::$serviceName, self::$className)->taskSyncDepartmentAws();
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}