<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-07-09 12:23:57
 */
namespace Mainto\Bridge\Invokes\BscFinanceBasic;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class BankCardController
 * @method listByCorporationIdByParams(array $params) 根据法人组织id查询银行卡号列表
 * @method bankCardPageListByParams(array $params) 银行卡号-列表-分页
 * @method bankCardAnnexUseByParams(array $params) 银行卡附件-使用
 * @method bankCardPullTaskByParams(array $params) 银行卡号-从保融拉取数据
 * @method bankCardPullByUpdateByParams(array $params) 银行卡号-按照时间区间从保融拉取数据
 * @method bankCardUpdateByParams(array $params) 银行卡号-更新
 * @method bankCardAnnexDeleteByParams(array $params) 银行卡附件删除
 * @method bankCardAnnexUploadTokenByParams(array $params) 银行卡附件-上传token
 * @method bankCardAnnexDownloadByParams(array $params) 银行卡附件下载
 * @method bankCardAnnexUploadByParams(array $params) 银行卡附件上传
 * @method bankCardAnnexListByParams(array $params) 银行卡附件列表-不分页
 * @method bankCardAnnexAbolishByParams(array $params) 银行卡附件-作废
 * @method bankCardDetailByParams(array $params) 银行卡号-详情
 */
class BankCardController {
    private static string $serviceName = "BscFinanceBasic";

    private static string $className = "BankCardController";

    /**
     * 根据法人组织id查询银行卡号列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function listByCorporationId () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->listByCorporationId([]),
            "\Mainto\Bridge\Structs\BscFinanceBasic\Com\Mainto\Finance\Basic\Data\Api\Model\Res\Bank\BankCardDetailDTO[]"
        );
    }

    /**
     * 银行卡号-列表-分页
     * @return  \Mainto\Bridge\Structs\BscFinanceBasic\Com\Mainto\Finance\Basic\Data\Api\Model\Res\Bank\BankCardPageListDTO
    */
    public static function bankCardPageList (\Mainto\Bridge\Structs\BscFinanceBasic\Com\Mainto\Finance\Basic\Data\Api\Model\Req\Bank\BankCardPageQueryReq $bankCardPageQueryReq) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->bankCardPageList($bankCardPageQueryReq),
            "\Mainto\Bridge\Structs\BscFinanceBasic\Com\Mainto\Finance\Basic\Data\Api\Model\Res\Bank\BankCardPageListDTO"
        );
    }

    /**
     * 银行卡附件-使用
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function bankCardAnnexUse () {
        return RpcClass::getClass(self::$serviceName, self::$className)->bankCardAnnexUse([]);
    }

    /**
     * 银行卡号-从保融拉取数据
     * @return  bool
    */
    public static function bankCardPullTask () {
        return RpcClass::getClass(self::$serviceName, self::$className)->bankCardPullTask();
    }

    /**
     * 银行卡号-按照时间区间从保融拉取数据
     * @return  bool
    */
    public static function bankCardPullByUpdate (?\Mainto\Bridge\Structs\BscFinanceBasic\Com\Mainto\Finance\Basic\Data\Api\Model\Req\Bank\BankCardPullReq $bankCardPullReq = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->bankCardPullByUpdate($bankCardPullReq);
    }

    /**
     * 银行卡号-更新
     * @return  bool
    */
    public static function bankCardUpdate (\Mainto\Bridge\Structs\BscFinanceBasic\Com\Mainto\Finance\Basic\Data\Api\Model\Req\Bank\BankCardUpdateReq $bankCardUpdateReq) {
        return RpcClass::getClass(self::$serviceName, self::$className)->bankCardUpdate($bankCardUpdateReq);
    }

    /**
     * 银行卡附件删除
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function bankCardAnnexDelete () {
        return RpcClass::getClass(self::$serviceName, self::$className)->bankCardAnnexDelete([]);
    }

    /**
     * 银行卡附件-上传token
     * @return  \Mainto\Bridge\Structs\BscFinanceBasic\Com\Mainto\Finance\Basic\Data\Api\Model\Res\Qiniu\QiniuTokenDTO
    */
    public static function bankCardAnnexUploadToken () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->bankCardAnnexUploadToken(),
            "\Mainto\Bridge\Structs\BscFinanceBasic\Com\Mainto\Finance\Basic\Data\Api\Model\Res\Qiniu\QiniuTokenDTO"
        );
    }

    /**
     * 银行卡附件下载
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\BscFinanceBasic\Com\Mainto\Finance\Basic\Data\Api\Model\Res\Qiniu\QiniuDownloadDTO
    */
    public static function bankCardAnnexDownload () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->bankCardAnnexDownload([]),
            "\Mainto\Bridge\Structs\BscFinanceBasic\Com\Mainto\Finance\Basic\Data\Api\Model\Res\Qiniu\QiniuDownloadDTO"
        );
    }

    /**
     * 银行卡附件上传
     * @return  bool
    */
    public static function bankCardAnnexUpload (\Mainto\Bridge\Structs\BscFinanceBasic\Com\Mainto\Finance\Basic\Data\Api\Model\Req\Bank\BankCardAnnexUploadReq $bankCardAnnexUploadReq) {
        return RpcClass::getClass(self::$serviceName, self::$className)->bankCardAnnexUpload($bankCardAnnexUploadReq);
    }

    /**
     * 银行卡附件列表-不分页
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function bankCardAnnexList () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->bankCardAnnexList([]),
            "\Mainto\Bridge\Structs\BscFinanceBasic\Com\Mainto\Finance\Basic\Data\Api\Model\Res\Bank\BankCardAnnexDTO[]"
        );
    }

    /**
     * 银行卡附件-作废
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function bankCardAnnexAbolish () {
        return RpcClass::getClass(self::$serviceName, self::$className)->bankCardAnnexAbolish([]);
    }

    /**
     * 银行卡号-详情
     * @return  \Mainto\Bridge\Structs\BscFinanceBasic\Com\Mainto\Finance\Basic\Data\Api\Model\Res\Bank\BankCardDetailDTO
    */
    public static function bankCardDetail (\Mainto\Bridge\Structs\BscFinanceBasic\Com\Mainto\Finance\Basic\Data\Api\Model\Req\Bank\BankCardIdReq $bankCardIdReq) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->bankCardDetail($bankCardIdReq),
            "\Mainto\Bridge\Structs\BscFinanceBasic\Com\Mainto\Finance\Basic\Data\Api\Model\Res\Bank\BankCardDetailDTO"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}