<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-05-11 09:59:48
 */
namespace Mainto\Bridge\Invokes\BscFinanceBasic;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class CorporationController
 * @method corporationDetailByParams(array $params) 财务法人组织详情
 * @method corporationBpmUpdateByParams(array $params) Bpm更新财务法人组织
 * @method saveCorporationByParams(array $params) 更新财务法人组织
 * @method getCorporationListByParams(array $params) 财务法人组织列表
 * @method corporationTaxTypeListByParams(array $params) 纳税类型列表
 * @method corporationTaxInvoiceDetailByParams(array $params) 财务法人组织-开票-详情
 * @method corporationTaxInvoiceCreateByParams(array $params) 财务法人组织-开票-创建
 * @method getCorporationPageListByParams(array $params) 财务法人组织分页列表
 * @method saveCorporationTaxTypeByParams(array $params) 更新组织纳税类型
 * @method corporationTaxRateListByParams(array $params) 纳税税率列表
 * @method addCorporationByParams(array $params) 创建财务法人组织
 * @method saveCorporationTaxRateByParams(array $params) 更新组织纳税税率
 * @method corporationBpmCreateByParams(array $params) Bpm创建财务法人组织
 * @method corporationTaxInvoiceUpdateByParams(array $params) 财务法人组织-开票-更新
 * @method corporationBpmDeregisterByParams(array $params) Bpm注销财务法人组织
 */
class CorporationController {
    private static string $serviceName = "BscFinanceBasic";

    private static string $className = "CorporationController";

    /**
     * 财务法人组织详情
     * @return  \Mainto\Bridge\Structs\BscFinanceBasic\Com\Mainto\Finance\Basic\Data\Api\Model\Res\CorporationInfoDTO
    */
    public static function corporationDetail (\Mainto\Bridge\Structs\BscFinanceBasic\Com\Mainto\Finance\Basic\Data\Api\Model\Req\CorporationIdReq $corporationIdReq) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->corporationDetail($corporationIdReq),
            "\Mainto\Bridge\Structs\BscFinanceBasic\Com\Mainto\Finance\Basic\Data\Api\Model\Res\CorporationInfoDTO"
        );
    }
    /**
     * Bpm更新财务法人组织
     * @return  bool
    */
    public static function corporationBpmUpdate (\Mainto\Bridge\Structs\BscFinanceBasic\Com\Mainto\Finance\Basic\Data\Api\Model\Req\Corporation\CorporationUpdateReq $corporationUpdateReq) {
        return RpcClass::getClass(self::$serviceName, self::$className)->corporationBpmUpdate($corporationUpdateReq);
    }
    /**
     * 更新财务法人组织
     * @return  bool
    */
    public static function saveCorporation (?\Mainto\Bridge\Structs\BscFinanceBasic\Com\Mainto\Finance\Basic\Data\Api\Model\Req\SaveCorporationReq $saveCorporationReq = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->saveCorporation($saveCorporationReq);
    }
    /**
     * 财务法人组织列表
     * @return  \Mainto\Bridge\Structs\BscFinanceBasic\Com\Mainto\Finance\Basic\Data\Api\Model\Res\CorporationListDTO
    */
    public static function getCorporationList (?\Mainto\Bridge\Structs\BscFinanceBasic\Com\Mainto\Finance\Basic\Data\Api\Model\Req\CorporationQueryReq $corporationQueryReq = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getCorporationList($corporationQueryReq),
            "\Mainto\Bridge\Structs\BscFinanceBasic\Com\Mainto\Finance\Basic\Data\Api\Model\Res\CorporationListDTO"
        );
    }
    /**
     * 纳税类型列表
     * @return  \Mainto\Bridge\Structs\BscFinanceBasic\Com\Mainto\Finance\Basic\Data\Api\Model\Res\CorporationTaxTypeListDTO
    */
    public static function corporationTaxTypeList (\Mainto\Bridge\Structs\BscFinanceBasic\Com\Mainto\Finance\Basic\Data\Api\Model\Req\CorporationIdReq $corporationIdReq) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->corporationTaxTypeList($corporationIdReq),
            "\Mainto\Bridge\Structs\BscFinanceBasic\Com\Mainto\Finance\Basic\Data\Api\Model\Res\CorporationTaxTypeListDTO"
        );
    }
    /**
     * 财务法人组织-开票-详情
     * @return  \Mainto\Bridge\Structs\BscFinanceBasic\Com\Mainto\Finance\Basic\Data\Api\Model\Res\Corporation\CorporationTaxInvoiceDetailDTO
    */
    public static function corporationTaxInvoiceDetail (\Mainto\Bridge\Structs\BscFinanceBasic\Com\Mainto\Finance\Basic\Data\Api\Model\Req\CorporationIdReq $corporationIdReq) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->corporationTaxInvoiceDetail($corporationIdReq),
            "\Mainto\Bridge\Structs\BscFinanceBasic\Com\Mainto\Finance\Basic\Data\Api\Model\Res\Corporation\CorporationTaxInvoiceDetailDTO"
        );
    }
    /**
     * 财务法人组织-开票-创建
     * @return  bool
    */
    public static function corporationTaxInvoiceCreate (\Mainto\Bridge\Structs\BscFinanceBasic\Com\Mainto\Finance\Basic\Data\Api\Model\Req\Corporation\CorporationTaxInvoiceCreateReq $corporationTaxInvoiceCreateReq) {
        return RpcClass::getClass(self::$serviceName, self::$className)->corporationTaxInvoiceCreate($corporationTaxInvoiceCreateReq);
    }
    /**
     * 财务法人组织分页列表
     * @return  \Mainto\Bridge\Structs\BscFinanceBasic\Com\Mainto\Finance\Basic\Data\Api\Model\Res\CorporationPageListDTO
    */
    public static function getCorporationPageList (?\Mainto\Bridge\Structs\BscFinanceBasic\Com\Mainto\Finance\Basic\Data\Api\Model\Req\CorporationPageQueryReq $corporationPageQueryReq = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getCorporationPageList($corporationPageQueryReq),
            "\Mainto\Bridge\Structs\BscFinanceBasic\Com\Mainto\Finance\Basic\Data\Api\Model\Res\CorporationPageListDTO"
        );
    }
    /**
     * 更新组织纳税类型
     * @return  bool
    */
    public static function saveCorporationTaxType (?\Mainto\Bridge\Structs\BscFinanceBasic\Com\Mainto\Finance\Basic\Data\Api\Model\Req\SaveCorporationTaxTypeReq $saveCorporationTaxTypeReq = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->saveCorporationTaxType($saveCorporationTaxTypeReq);
    }
    /**
     * 纳税税率列表
     * @return  \Mainto\Bridge\Structs\BscFinanceBasic\Com\Mainto\Finance\Basic\Data\Api\Model\Res\CorporationTaxRateListDTO
    */
    public static function corporationTaxRateList (\Mainto\Bridge\Structs\BscFinanceBasic\Com\Mainto\Finance\Basic\Data\Api\Model\Req\CorporationIdReq $corporationIdReq) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->corporationTaxRateList($corporationIdReq),
            "\Mainto\Bridge\Structs\BscFinanceBasic\Com\Mainto\Finance\Basic\Data\Api\Model\Res\CorporationTaxRateListDTO"
        );
    }
    /**
     * 创建财务法人组织
     * @return  bool
    */
    public static function addCorporation (?\Mainto\Bridge\Structs\BscFinanceBasic\Com\Mainto\Finance\Basic\Data\Api\Model\Req\AddCorporationReq $addCorporationReq = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addCorporation($addCorporationReq);
    }
    /**
     * 更新组织纳税税率
     * @return  bool
    */
    public static function saveCorporationTaxRate (?\Mainto\Bridge\Structs\BscFinanceBasic\Com\Mainto\Finance\Basic\Data\Api\Model\Req\SaveCorporationTaxRateReq $saveCorporationTaxRateReq = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->saveCorporationTaxRate($saveCorporationTaxRateReq);
    }
    /**
     * Bpm创建财务法人组织
     * @return  bool
    */
    public static function corporationBpmCreate (\Mainto\Bridge\Structs\BscFinanceBasic\Com\Mainto\Finance\Basic\Data\Api\Model\Req\Corporation\CorporationCreateReq $corporationCreateReq) {
        return RpcClass::getClass(self::$serviceName, self::$className)->corporationBpmCreate($corporationCreateReq);
    }
    /**
     * 财务法人组织-开票-更新
     * @return  bool
    */
    public static function corporationTaxInvoiceUpdate (\Mainto\Bridge\Structs\BscFinanceBasic\Com\Mainto\Finance\Basic\Data\Api\Model\Req\Corporation\CorporationTaxInvoiceUpdateReq $corporationTaxInvoiceUpdateReq) {
        return RpcClass::getClass(self::$serviceName, self::$className)->corporationTaxInvoiceUpdate($corporationTaxInvoiceUpdateReq);
    }
    /**
     * Bpm注销财务法人组织
     * @return  bool
    */
    public static function corporationBpmDeregister (\Mainto\Bridge\Structs\BscFinanceBasic\Com\Mainto\Finance\Basic\Data\Api\Model\Req\Corporation\CorporationDeregisterReq $corporationDeregisterReq) {
        return RpcClass::getClass(self::$serviceName, self::$className)->corporationBpmDeregister($corporationDeregisterReq);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}