<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-09-14 12:15:14
 */
namespace Mainto\Bridge\Invokes\BscFinanceBasic;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class BankCardController
 */
class BankCardController {
    private static string $serviceName = "BscFinanceBasic";

    private static string $className = "BankCardController";

    /**
     * 根据法人组织id查询银行卡号列表
     * @return  array
    */
    public static function listByCorporationId (int $corporationId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->listByCorporationId(["corporationId" => $corporationId]),
            "\Mainto\Bridge\Structs\BscFinanceBasic\Com\Mainto\Finance\Basic\Data\Api\Model\Res\Bank\BankCardDetailDTO[]"
        );
    }
    /**
     * 银行卡号-列表-分页
     * @return  \Mainto\Bridge\Structs\BscFinanceBasic\Com\Mainto\Finance\Basic\Data\Api\Model\Res\Bank\BankCardPageListDTO
    */
    public static function bankCardPageList (\Mainto\Bridge\Structs\BscFinanceBasic\Com\Mainto\Finance\Basic\Data\Api\Model\Req\Bank\BankCardPageQueryReq $bankCardPageQueryReq) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->bankCardPageList($bankCardPageQueryReq),
            "\Mainto\Bridge\Structs\BscFinanceBasic\Com\Mainto\Finance\Basic\Data\Api\Model\Res\Bank\BankCardPageListDTO"
        );
    }
    /**
     * 银行卡号-从保融拉取数据
     * @return  bool
    */
    public static function bankCardPullTask () {
        return RpcClass::getClass(self::$serviceName, self::$className)->bankCardPullTask();
    }
    /**
     * 银行卡号-按照时间区间从保融拉取数据
     * @return  bool
    */
    public static function bankCardPullByUpdate (?\Mainto\Bridge\Structs\BscFinanceBasic\Com\Mainto\Finance\Basic\Data\Api\Model\Req\Bank\BankCardPullReq $bankCardPullReq = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->bankCardPullByUpdate($bankCardPullReq);
    }
    /**
     * 银行卡号-更新
     * @return  bool
    */
    public static function bankCardUpdate (\Mainto\Bridge\Structs\BscFinanceBasic\Com\Mainto\Finance\Basic\Data\Api\Model\Req\Bank\BankCardUpdateReq $bankCardUpdateReq) {
        return RpcClass::getClass(self::$serviceName, self::$className)->bankCardUpdate($bankCardUpdateReq);
    }
    /**
     * 银行卡号-详情
     * @return  \Mainto\Bridge\Structs\BscFinanceBasic\Com\Mainto\Finance\Basic\Data\Api\Model\Res\Bank\BankCardDetailDTO
    */
    public static function bankCardDetail (\Mainto\Bridge\Structs\BscFinanceBasic\Com\Mainto\Finance\Basic\Data\Api\Model\Req\Bank\BankCardIdReq $bankCardIdReq) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->bankCardDetail($bankCardIdReq),
            "\Mainto\Bridge\Structs\BscFinanceBasic\Com\Mainto\Finance\Basic\Data\Api\Model\Res\Bank\BankCardDetailDTO"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}