<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-04-18 13:53:23
 */
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Order
 * @method createMultiOrderByParams(array $params) 多门店下单
 * @method orderPayAfterDetailByParams(array $params) 订单支付页详情
 * @method detailByParams(array $params) 订单详情
 * @method getAggregateOrderDetailByParams(array $params) 获得聚合订单详情
 * @method encodeOrderDetailByParams(array $params) 加密订单详情
 * @method listByParams(array $params) 订单列表
 * @method cancelByParams(array $params) 用户取消订单
 * @method deleteByParams(array $params) 用户删除订单
 * @method bindUserByParams(array $params) 绑定订单
 * @method getRefundReasonByParams(array $params) 退款理由
 * @method getUserConsumeStoreIdsByParams(array $params) 用户消费门店
 * @method orderAllRefundByParams(array $params) 订单全部退款hook
 * @method photoByParams(array $params) 获取云端原片地址
 * @method changeAppointmentByParams(array $params) 修改预约
 * @method checkChangeAppointmentByParams(array $params) 判断是否可修改预约时间
 * @method christmasJumpTypeByParams(array $params) 获取圣诞订单完成后需跳转活动类型
 * @method getPrepareShootRemindByParams(array $params) 获取订单的拍摄提醒
 * @method detailV1ByParams(array $params) 订单详情.v1
 * @method listV1ByParams(array $params) 订单列表.v1
 * @method listV2ByParams(array $params) 订单列表.v2
 * @method cancelV1ByParams(array $params) 用户取消订单.v1
 * @method deleteV1ByParams(array $params) 用户删除订单.v1
 * @method getRefundReasonV1ByParams(array $params) 退款理由.v1
 * @method getUserConsumeStoreIdsV1ByParams(array $params) 用户消费门店.v1
 * @method changeAppointmentV1ByParams(array $params) 修改预约V1
 * @method createMultiOrderV1ByParams(array $params) 多门店下单.v1
 * @method orderPayAfterDetailV1ByParams(array $params) 订单支付页详情
 * @method christmasJumpTypeV1ByParams(array $params) 获取圣诞订单完成后需跳转活动类型V1
 * @method getPrepareShootRemindV1ByParams(array $params) 获取订单的拍摄提醒V1
 */
class Order {
    private static string $serviceName = "AppointmentPlatform";

    private static string $className = "Order\\Order";

    /**
     * 多门店下单
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\CreateOrderResDTO
    */
    public static function createMultiOrder (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Order\CreateOrderCmd $createOrderCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->createMultiOrder($createOrderCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\CreateOrderResDTO"
        );
    }
    /**
     * 订单支付页详情
     * @return  array
    */
    public static function orderPayAfterDetail (array $orderNums) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->orderPayAfterDetail(["orderNums" => $orderNums]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OrderPayAfterInfoDTO[]"
        );
    }
    /**
     * 订单详情
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OrderInfoDTO
    */
    public static function detail (?\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Order\OrderDetailCmd $orderDetailCmd = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->detail($orderDetailCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OrderInfoDTO"
        );
    }
    /**
     * 获得聚合订单详情
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\AggregateOrder\AggregateOrderDTO
    */
    public static function getAggregateOrderDetail (string $orderNo) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getAggregateOrderDetail(["orderNo" => $orderNo]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\AggregateOrder\AggregateOrderDTO"
        );
    }
    /**
     * 加密订单详情
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OrderInfoDTO
    */
    public static function encodeOrderDetail (string $encodeOrderNum) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->encodeOrderDetail(["encodeOrderNum" => $encodeOrderNum]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OrderInfoDTO"
        );
    }
    /**
     * 订单列表
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OrderListDTO
    */
    public static function list (?\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Order\OrderListCmd $orderListCmd = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->list($orderListCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OrderListDTO"
        );
    }
    /**
     * 用户取消订单
     * @return  bool
    */
    public static function cancel (string $orderNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->cancel(["orderNo" => $orderNo]);
    }
    /**
     * 用户删除订单
     * @return  bool
    */
    public static function delete (string $orderNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delete(["orderNo" => $orderNo]);
    }
    /**
     * 绑定订单
     * @return  bool
    */
    public static function bindUser (string $orderNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->bindUser(["orderNo" => $orderNo]);
    }
    /**
     * 退款理由
     * @return  array
    */
    public static function getRefundReason () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getRefundReason([]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\OrderRefund\RefundReasonDTO[]"
        );
    }
    /**
     * 用户消费门店
     * @return  array
    */
    public static function getUserConsumeStoreIds () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUserConsumeStoreIds();
    }
    /**
     * 订单全部退款hook
     * @return  bool
    */
    public static function orderAllRefund () {
        return RpcClass::getClass(self::$serviceName, self::$className)->orderAllRefund([]);
    }
    /**
     * 获取云端原片地址
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Photo\OrderPhotoDTO
    */
    public static function photo (string $orderNum) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->photo(["orderNum" => $orderNum]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Photo\OrderPhotoDTO"
        );
    }
    /**
     * 修改预约
     * @return  bool
    */
    public static function changeAppointment (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Order\ChangeAppointmentCmd $changeAppointmentCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changeAppointment($changeAppointmentCmd);
    }
    /**
     * 判断是否可修改预约时间
     * @return  bool
    */
    public static function checkChangeAppointment (string $orderNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkChangeAppointment(["orderNo" => $orderNo]);
    }
    /**
     * 获取圣诞订单完成后需跳转活动类型
     * @return  string
    */
    public static function christmasJumpType () {
        return RpcClass::getClass(self::$serviceName, self::$className)->christmasJumpType();
    }
    /**
     * 获取订单的拍摄提醒
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\PrepareShootRemindDTO
    */
    public static function getPrepareShootRemind (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Order\PrepareShootRemindCmd $prepareShootRemindCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getPrepareShootRemind($prepareShootRemindCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\PrepareShootRemindDTO"
        );
    }
    /**
     * 订单详情.v1
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OrderInfoDTO
    */
    public static function detailV1 (?\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Order\OrderDetailCmd $orderDetailCmd = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->detailV1($orderDetailCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OrderInfoDTO"
        );
    }
    /**
     * 订单列表.v1
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OrderListDTO
    */
    public static function listV1 (?\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Order\OrderListCmd $orderListCmd = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->listV1($orderListCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OrderListDTO"
        );
    }
    /**
     * 订单列表.v2
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OrderListDTO
    */
    public static function listV2 (?\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Order\OrderListCmd $orderListCmd = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->listV2($orderListCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OrderListDTO"
        );
    }
    /**
     * 用户取消订单.v1
     * @return  bool
    */
    public static function cancelV1 (string $orderNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->cancelV1(["orderNo" => $orderNo]);
    }
    /**
     * 用户删除订单.v1
     * @return  bool
    */
    public static function deleteV1 (string $orderNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteV1(["orderNo" => $orderNo]);
    }
    /**
     * 退款理由.v1
     * @return  array
    */
    public static function getRefundReasonV1 () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getRefundReasonV1([]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\OrderRefund\RefundReasonDTO[]"
        );
    }
    /**
     * 用户消费门店.v1
     * @return  array
    */
    public static function getUserConsumeStoreIdsV1 () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUserConsumeStoreIdsV1();
    }
    /**
     * 修改预约V1
     * @return  bool
    */
    public static function changeAppointmentV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Order\ChangeAppointmentCmd $changeAppointmentCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changeAppointmentV1($changeAppointmentCmd);
    }
    /**
     * 多门店下单.v1
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\CreateOrderResDTO
    */
    public static function createMultiOrderV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Order\CreateOrderCmd $createOrderCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->createMultiOrderV1($createOrderCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\CreateOrderResDTO"
        );
    }
    /**
     * 订单支付页详情
     * @return  array
    */
    public static function orderPayAfterDetailV1 (array $orderNums) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->orderPayAfterDetailV1(["orderNums" => $orderNums]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OrderPayAfterInfoDTO[]"
        );
    }
    /**
     * 获取圣诞订单完成后需跳转活动类型V1
     * @return  string
    */
    public static function christmasJumpTypeV1 () {
        return RpcClass::getClass(self::$serviceName, self::$className)->christmasJumpTypeV1();
    }
    /**
     * 获取订单的拍摄提醒V1
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\PrepareShootRemindDTO
    */
    public static function getPrepareShootRemindV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Order\PrepareShootRemindCmd $prepareShootRemindCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getPrepareShootRemindV1($prepareShootRemindCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\PrepareShootRemindDTO"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}