<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-04-12 15:58:01
 */
namespace Mainto\Bridge\Invokes\AppointmentPlatform\ProductNew;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Product
 * @method productLayerImgByParams(array $params) 获取产品弹窗图片
 * @method getProductTagsByParams(array $params) 获取产品标签list
 * @method getCatalogueListByParams(array $params) 获取目录list
 * @method getConfigCityListByParams(array $params) 获取推荐配置[猜你喜欢]
 * @method getCategoryProductsByCityIdByParams(array $params) 获取某个城市下某个类目所有的产品
 * @method getBrandRecommendByParams(array $params) 获取全部推荐产品
 * @method getCouldPhotoCityByParams(array $params) 获取产品可拍摄城市
 * @method productLayerImgV1ByParams(array $params) 获取产品弹窗图片v1
 * @method getCategoryProductsByCityIdV1ByParams(array $params) 获取某个城市下某个类目所有的产品.v1
 * @method getCouldPhotoCityV1ByParams(array $params) 获取产品可拍摄城市v1
 * @method getCatalogueListV1ByParams(array $params) 获取目录list-v1
 * @method getProductTagsV1ByParams(array $params) 获取产品标签list-v1
 * @method getBrandRecommendV1ByParams(array $params) 获取全部推荐产品-v1
 * @method getConfigCityListV1ByParams(array $params) 获取推荐配置[猜你喜欢]-v1
 * @method getCategoryProductsByCityIdV2ByParams(array $params) 获取某个城市下某个类目所有的产品.v2
 */
class Product {
    private static string $serviceName = "AppointmentPlatform";

    private static string $className = "ProductNew\\Product";

    /**
     * 获取产品弹窗图片
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ProductLayerImgDTO
    */
    public static function productLayerImg (int $id) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->productLayerImg(["id" => $id]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ProductLayerImgDTO"
        );
    }
    /**
     * 获取产品标签list
     * @return  array
    */
    public static function getProductTags (?\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Product\ProductTagsCmd $productTagsCmd = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getProductTags($productTagsCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ProductTagDTO[]"
        );
    }
    /**
     * 获取目录list
     * @return  array
    */
    public static function getCatalogueList (string $brand, int $cityId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getCatalogueList(["brand" => $brand, "cityId" => $cityId]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\CatalogueDTO[]"
        );
    }
    /**
     * 获取推荐配置[猜你喜欢]
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ConfigCityListDTO
    */
    public static function getConfigCityList (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Product\ConfigCityListCmd $configCityListCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getConfigCityList($configCityListCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ConfigCityListDTO"
        );
    }
    /**
     * 获取某个城市下某个类目所有的产品
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ProductCategoryBaseWithChildrenDTO
    */
    public static function getCategoryProductsByCityId (int $cityId, int $categoryId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getCategoryProductsByCityId(["cityId" => $cityId, "categoryId" => $categoryId]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ProductCategoryBaseWithChildrenDTO"
        );
    }
    /**
     * 获取全部推荐产品
     * @return  array
    */
    public static function getBrandRecommend (int $cityId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getBrandRecommend(["cityId" => $cityId]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\BrandRecommendDTO[]"
        );
    }
    /**
     * 获取产品可拍摄城市
     * @return  array
    */
    public static function getCouldPhotoCity () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCouldPhotoCity([]);
    }
    /**
     * 获取产品弹窗图片v1
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ProductLayerImgDTO
    */
    public static function productLayerImgV1 (int $id) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->productLayerImgV1(["id" => $id]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ProductLayerImgDTO"
        );
    }
    /**
     * 获取某个城市下某个类目所有的产品.v1
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ProductCategoryBaseWithChildrenDTO
    */
    public static function getCategoryProductsByCityIdV1 (int $cityId, int $categoryId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getCategoryProductsByCityIdV1(["cityId" => $cityId, "categoryId" => $categoryId]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ProductCategoryBaseWithChildrenDTO"
        );
    }
    /**
     * 获取产品可拍摄城市v1
     * @return  array
    */
    public static function getCouldPhotoCityV1 () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCouldPhotoCityV1([]);
    }
    /**
     * 获取目录list-v1
     * @return  array
    */
    public static function getCatalogueListV1 (string $brand, int $cityId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getCatalogueListV1(["brand" => $brand, "cityId" => $cityId]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\CatalogueDTO[]"
        );
    }
    /**
     * 获取产品标签list-v1
     * @return  array
    */
    public static function getProductTagsV1 (?\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Product\ProductTagsCmd $productTagsCmd = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getProductTagsV1($productTagsCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ProductTagDTO[]"
        );
    }
    /**
     * 获取全部推荐产品-v1
     * @return  array
    */
    public static function getBrandRecommendV1 (int $cityId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getBrandRecommendV1(["cityId" => $cityId]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\BrandRecommendDTO[]"
        );
    }
    /**
     * 获取推荐配置[猜你喜欢]-v1
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ConfigCityListDTO
    */
    public static function getConfigCityListV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Product\ConfigCityListCmd $configCityListCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getConfigCityListV1($configCityListCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ConfigCityListDTO"
        );
    }
    /**
     * 获取某个城市下某个类目所有的产品.v2
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ProductCategoryBaseWithChildrenDTO
    */
    public static function getCategoryProductsByCityIdV2 (int $cityId, int $categoryId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getCategoryProductsByCityIdV2(["cityId" => $cityId, "categoryId" => $categoryId]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ProductCategoryBaseWithChildrenDTO"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}