<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-03-06 16:48:12
 */
namespace Mainto\Bridge\Invokes\AppointmentPlatform\OrderNew;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Order
 */
class Order {
    private static string $serviceName = "AppointmentPlatform";

    private static string $className = "OrderNew\\Order";

    /**
     * 获得首页订单
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\IndexOrderDTO
    */
    public static function getIndexOrder () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getIndexOrder(),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\IndexOrderDTO"
        );
    }
    /**
     * 是否显示情侣会员引导弹窗
     * @return  bool
    */
    public static function isShowCpMemberLayer (int $orderId, string $orderNum) {
        return RpcClass::getClass(self::$serviceName, self::$className)->isShowCpMemberLayer(["orderId" => $orderId, "orderNum" => $orderNum]);
    }
    /**
     * 订单列表展示
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OrderListJumpDTO
    */
    public static function getOrderListJumpList (?\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Common\JumpPageCmd $jumpPageCmd = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getOrderListJumpList($jumpPageCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OrderListJumpDTO"
        );
    }
    /**
     * 订单灰度规则类型详情
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OrderHitGrayRuleDetailDTO
    */
    public static function orderHitGrayRuleDetail (int $orderId, string $orderNum) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->orderHitGrayRuleDetail(["orderId" => $orderId, "orderNum" => $orderNum]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OrderHitGrayRuleDetailDTO"
        );
    }
    /**
     * 确认服务完成
     * @return  bool
    */
    public static function confirmServiceCompleted (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Order\ConfirmServiceCompletedCmd $confirmServiceCompletedCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->confirmServiceCompleted($confirmServiceCompletedCmd);
    }
    /**
     * 获取灰度门店
     * @return  array
    */
    public static function getGrayStoreIds () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getGrayStoreIds();
    }
    /**
     * 获得首页订单.v1
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\IndexOrderDTO
    */
    public static function getIndexOrderV1 () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getIndexOrderV1(),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\IndexOrderDTO"
        );
    }
    /**
     * 是否显示情侣会员引导弹窗v1
     * @return  bool
    */
    public static function isShowCpMemberLayerV1 (int $orderId, string $orderNum) {
        return RpcClass::getClass(self::$serviceName, self::$className)->isShowCpMemberLayerV1(["orderId" => $orderId, "orderNum" => $orderNum]);
    }
    /**
     * 获取app订单列表是否跳转v1
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OrderListJumpDTO
    */
    public static function getOrderListJumpListV1 (?\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Common\JumpPageCmd $jumpPageCmd = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getOrderListJumpListV1($jumpPageCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OrderListJumpDTO"
        );
    }
    /**
     * 订单灰度规则类型详情.v1
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OrderHitGrayRuleDetailDTO
    */
    public static function orderHitGrayRuleDetailV1 (int $orderId, string $orderNum) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->orderHitGrayRuleDetailV1(["orderId" => $orderId, "orderNum" => $orderNum]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OrderHitGrayRuleDetailDTO"
        );
    }
    /**
     * 确认服务完成v1
     * @return  bool
    */
    public static function confirmServiceCompletedV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Order\ConfirmServiceCompletedCmd $confirmServiceCompletedCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->confirmServiceCompletedV1($confirmServiceCompletedCmd);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}