<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-12-22 14:55:43
 */
namespace Mainto\Bridge\Invokes\AppointmentPlatform\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class UserMember
 */
class UserMember {
    private static string $serviceName = "AppointmentPlatform";

    private static string $className = "User\\UserMember";

    /**
     * 用户获取生日礼遇零售产品
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\MemberRetailProduct\MemberRetailProductDTO
    */
    public static function getBirthGift (int $userId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getBirthGift(["userId" => $userId]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\MemberRetailProduct\MemberRetailProductDTO"
        );
    }
    /**
     * 兑换生日礼遇
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\MemberRetailProduct\MemberRetailProductExchangeInfoDTO
    */
    public static function exchangeBirthGift (int $userId, int $orderId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->exchangeBirthGift(["userId" => $userId, "orderId" => $orderId]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\MemberRetailProduct\MemberRetailProductExchangeInfoDTO"
        );
    }
    /**
     * 用户是否已发送生日券[crm也在使用]
     * @return  bool
    */
    public static function hasSentBirthCoupon (int $userId, string $year = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->hasSentBirthCoupon(["userId" => $userId, "year" => $year]);
    }
    /**
     * 添加新版会员弹框记录
     * @return  bool
    */
    public static function setMemberUpgradeTag (int $userId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setMemberUpgradeTag(["userId" => $userId]);
    }
    /**
     * 删除会员升级弹框标记
     * @return  bool
    */
    public static function alertCheck (int $userId = 0) {
        return RpcClass::getClass(self::$serviceName, self::$className)->alertCheck(["userId" => $userId]);
    }
    /**
     * 获取会员权益
     * @return  array
    */
    public static function listWelfare () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->listWelfare(),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\MemberWelfare\WelfareDetailDTO[]"
        );
    }
    /**
     * 获取会员权益.bridge
     * @return  array
    */
    public static function listWelfareWithBirthGiftWaitingStatus (int $userId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->listWelfareWithBirthGiftWaitingStatus(["userId" => $userId]);
    }
    /**
     * 会员活动列表
     * @return  array
    */
    public static function listMemberActivities (array $types = [], int $userId = 0) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->listMemberActivities(["types" => $types, "userId" => $userId]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\MemberActivity\MemberActivityDTO[]"
        );
    }
    /**
     * 领取权益美学生活礼遇
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\MemberRetailProduct\MemberRetailProductExchangeInfoDTO
    */
    public static function receiveWelfareRetail (int $userId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->receiveWelfareRetail(["userId" => $userId]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\MemberRetailProduct\MemberRetailProductExchangeInfoDTO"
        );
    }
    /**
     * 获取用户纪念值记录
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\MemberPointRecord\PointRecordListDTO
    */
    public static function getUserPointRecords (int $userId, int $page = 1, int $pageSize = 10) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getUserPointRecords(["userId" => $userId, "page" => $page, "pageSize" => $pageSize]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\MemberPointRecord\PointRecordListDTO"
        );
    }
    /**
     * 获取用户品牌探索标签
     * @return  array
    */
    public static function getUserBrands (int $userId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getUserBrands(["userId" => $userId]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\MemberBrand\UserBrandDTO[]"
        );
    }
    /**
     * 获取会员升级规则
     * @return  array
    */
    public static function memberRules () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->memberRules(),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\UserMember\UserMemberRuleDTO[]"
        );
    }
    /**
     * 用户获取生日礼遇零售产品.v1
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\MemberRetailProduct\MemberRetailProductDTO
    */
    public static function getBirthGiftV1 (int $userId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getBirthGiftV1(["userId" => $userId]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\MemberRetailProduct\MemberRetailProductDTO"
        );
    }
    /**
     * 兑换生日礼遇.v1
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\MemberRetailProduct\MemberRetailProductExchangeInfoDTO
    */
    public static function exchangeBirthGiftV1 (int $userId, int $orderId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->exchangeBirthGiftV1(["userId" => $userId, "orderId" => $orderId]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\MemberRetailProduct\MemberRetailProductExchangeInfoDTO"
        );
    }
    /**
     * 添加新版会员弹框记录.v1
     * @return  bool
    */
    public static function setMemberUpgradeTagV1 (int $userId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setMemberUpgradeTagV1(["userId" => $userId]);
    }
    /**
     * 删除会员升级弹框标记.v1
     * @return  bool
    */
    public static function alertCheckV1 (int $userId = 0) {
        return RpcClass::getClass(self::$serviceName, self::$className)->alertCheckV1(["userId" => $userId]);
    }
    /**
     * 获取会员权益.v1
     * @return  array
    */
    public static function listWelfareV1 () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->listWelfareV1(),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\MemberWelfare\WelfareDetailDTO[]"
        );
    }
    /**
     * 获取会员权益.v2
     * @return  array
    */
    public static function listWelfareV2 () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->listWelfareV2(),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\MemberWelfare\WelfareDetailDTO[]"
        );
    }
    /**
     * 会员活动列表.v1
     * @return  array
    */
    public static function listMemberActivitiesV1 (array $types = [], int $userId = 0) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->listMemberActivitiesV1(["types" => $types, "userId" => $userId]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\MemberActivity\MemberActivityDTO[]"
        );
    }
    /**
     * 领取权益美学生活礼遇.v1
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\MemberRetailProduct\MemberRetailProductExchangeInfoDTO
    */
    public static function receiveWelfareRetailV1 (int $userId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->receiveWelfareRetailV1(["userId" => $userId]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\MemberRetailProduct\MemberRetailProductExchangeInfoDTO"
        );
    }
    /**
     * 获取用户纪念值记录.v1
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\MemberPointRecord\PointRecordListDTO
    */
    public static function getUserPointRecordsV1 (int $userId, int $page = 1, int $pageSize = 10) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getUserPointRecordsV1(["userId" => $userId, "page" => $page, "pageSize" => $pageSize]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\MemberPointRecord\PointRecordListDTO"
        );
    }
    /**
     * 获取用户品牌探索标签.v1
     * @return  array
    */
    public static function getUserBrandsV1 (int $userId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getUserBrandsV1(["userId" => $userId]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\MemberBrand\UserBrandDTO[]"
        );
    }
    /**
     * 获取会员升级规则v1
     * @return  array
    */
    public static function memberRulesV1 () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->memberRulesV1(),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\UserMember\UserMemberRuleDTO[]"
        );
    }
    /**
     * 会员活动列表.v2
     * @return  array
    */
    public static function listMemberActivitiesV2 (array $types = [], int $userId = 0) {
        return RpcClass::getClass(self::$serviceName, self::$className)->listMemberActivitiesV2(["types" => $types, "userId" => $userId]);
    }
    /**
     * 获取用户纪念值记录.v2
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\MemberPointRecord\PointRecordListDTO
    */
    public static function getUserPointRecordsV2 (int $userId, int $page = 1, int $pageSize = 10) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getUserPointRecordsV2(["userId" => $userId, "page" => $page, "pageSize" => $pageSize]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\MemberPointRecord\PointRecordListDTO"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}