<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-12-22 14:55:43
 */
namespace Mainto\Bridge\Invokes\AppointmentPlatform\OrderNew;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Refund
 */
class Refund {
    private static string $serviceName = "AppointmentPlatform";

    private static string $className = "OrderNew\\Refund";

    /**
     * 获得退款数据
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\RefundDTO
    */
    public static function getRefundInfo (string $orderNo) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getRefundInfo(["orderNo" => $orderNo]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\RefundDTO"
        );
    }
    /**
     * 获得退款结果
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\RefundResultDTO
    */
    public static function getRefundResult (string $orderNo) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getRefundResult(["orderNo" => $orderNo]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\RefundResultDTO"
        );
    }
    /**
     * 订单退款
     * @return  bool
    */
    public static function createRefund (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Order\RefundCreateCmd $refundCreateCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createRefund($refundCreateCmd);
    }
    /**
     * 更新退款帐号
     * @return  bool
    */
    public static function updateRefund (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Order\RefundUpdateCmd $refundUpdateCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateRefund($refundUpdateCmd);
    }
    /**
     * 获得退款数据.v1
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\RefundDTO
    */
    public static function getRefundInfoV1 (string $orderNo) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getRefundInfoV1(["orderNo" => $orderNo]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\RefundDTO"
        );
    }
    /**
     * 获得退款结果.v1
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\RefundResultDTO
    */
    public static function getRefundResultV1 (string $orderNo) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getRefundResultV1(["orderNo" => $orderNo]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\RefundResultDTO"
        );
    }
    /**
     * 订单退款.v1
     * @return  bool
    */
    public static function createRefundV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Order\RefundCreateCmd $refundCreateCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createRefundV1($refundCreateCmd);
    }
    /**
     * 更新退款帐号.v1
     * @return  bool
    */
    public static function updateRefundV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Order\RefundUpdateCmd $refundUpdateCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateRefundV1($refundUpdateCmd);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}