<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-12-30 17:58:37
 */
namespace Mainto\Bridge\Invokes\AppointmentPlatform\MessageQueue;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class AggregateOrder
 * @method sendRefundingNotifyByParams(array $params) 聚合订单-退款申请事件
 * @method sendRefundSuccessNotifyByParams(array $params) 聚合订单-退款成功事件
 * @method sendPaidSuccessNotifyByParams(array $params) 聚合订单-支付抖音订单事件
 */
class AggregateOrder {
    private static string $serviceName = "AppointmentPlatform";

    private static string $className = "MessageQueue\\AggregateOrder";

    /**
     * 聚合订单-退款申请事件
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function sendRefundingNotify (string $aggregateOrderNo, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->sendRefundingNotify(array_merge($_params, ["aggregateOrderNo" => $aggregateOrderNo]));
    }

    /**
     * 聚合订单-退款成功事件
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function sendRefundSuccessNotify (string $aggregateOrderNo, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->sendRefundSuccessNotify(array_merge($_params, ["aggregateOrderNo" => $aggregateOrderNo]));
    }

    /**
     * 聚合订单-支付抖音订单事件
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function sendPaidSuccessNotify (string $aggregateOrderNo, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->sendPaidSuccessNotify(array_merge($_params, ["aggregateOrderNo" => $aggregateOrderNo]));
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}