<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-12-31 08:42:31
 */
namespace Mainto\Bridge\Invokes\AppointmentPlatform\MessageQueue;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Package
 * @method listenPackageUpByParams(array $params) 套餐上架消息
 * @method listenPackageDownByParams(array $params) 套餐下架消息
 * @method listenPackageUpdateByParams(array $params) 套餐更新消息,底层处理产品更新时也会发出包含该产品的套餐更新事件
 */
class Package {
    private static string $serviceName = "AppointmentPlatform";

    private static string $className = "MessageQueue\\Package";

    /**
     * 套餐上架消息
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function listenPackageUp (int $packageId, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->listenPackageUp(array_merge($_params, ["packageId" => $packageId]));
    }

    /**
     * 套餐下架消息
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function listenPackageDown (int $packageId, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->listenPackageDown(array_merge($_params, ["packageId" => $packageId]));
    }

    /**
     * 套餐更新消息,底层处理产品更新时也会发出包含该产品的套餐更新事件
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function listenPackageUpdate (int $packageId, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->listenPackageUpdate(array_merge($_params, ["packageId" => $packageId]));
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}