<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-12-19 11:18:52
 */
namespace Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Pay;

class CreatePayOrderCmd {
    /**
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Pay\PayOrderCmd[]
     * 创建的支付订单的订单信息
     * validation: 
     */
    public array $orders;
    /**
     * @var  string
     * 用户openId
     * validation: 
     */
    public string $openId = "";
    /**
     * @var  int
     * 发送支付链接的小伙伴id
     * validation: 
     */
    public int $sendUrlStaffId = 0;
    /**
     * @var  string
     * 支付链接创建时间
     * validation: 
     */
    public string $payUrlCreateTime = "";
    /**
     * @var  float
     * 支付金额
     * validation: 
     */
    public float $payMoney;
    /**
     * @var  null|string
     * 支付类型
     * validation: sometimes|in:PaymaxAlipay,PaymaxAlipayMiniApp,PaymaxWechat,PaymaxWXApp,Douyin
     */
    public ?string $payType = null;

    public function __construct (array $orders = [], float $payMoney = 0.0) {
        if (!is_null($orders)) {
            $this->orders = $orders;
        }
        if (!is_null($payMoney)) {
            $this->payMoney = $payMoney;
        }
    }

    public static function create(array $orders = [], float $payMoney = 0.0): self {
        return new self($orders, $payMoney);
    }

    public function setOrders(array $orders): self {
        $this->orders = $orders;

        return $this;
    }

    public function setOpenId(string $openId): self {
        $this->openId = $openId;

        return $this;
    }

    public function setSendUrlStaffId(int $sendUrlStaffId): self {
        $this->sendUrlStaffId = $sendUrlStaffId;

        return $this;
    }

    public function setPayUrlCreateTime(string $payUrlCreateTime): self {
        $this->payUrlCreateTime = $payUrlCreateTime;

        return $this;
    }

    public function setPayMoney(float $payMoney): self {
        $this->payMoney = $payMoney;

        return $this;
    }

    public function setPayType(?string $payType): self {
        $this->payType = $payType;

        return $this;
    }
}