<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-12-25 10:35:20
 */
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class SearchTerms
 * @method listByParams(array $params) 获取历史搜索词
 * @method batchDeleteByParams(array $params) 批量删除搜索词
 * @method deleteByParams(array $params) 删除搜索词
 * @method createByParams(array $params) 添加搜索词
 * @method listV1ByParams(array $params) 获取历史搜索词v1
 * @method batchDeleteV1ByParams(array $params) 批量删除搜索词v1
 * @method deleteV1ByParams(array $params) 删除搜索词v1
 * @method createV1ByParams(array $params) 添加搜索词v1
 */
class SearchTerms {
    private static string $serviceName = "AppointmentPlatform";

    private static string $className = "Product\\SearchTerms";

    /**
     * 获取历史搜索词
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function list () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->list(),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\SearchTerm\SearchTermInfoDTO[]"
        );
    }

    /**
     * 批量删除搜索词
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function batchDelete () {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchDelete();
    }

    /**
     * 删除搜索词
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function delete (string $id, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delete(array_merge($_params, ["id" => $id]));
    }

    /**
     * 添加搜索词
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function create (string $content, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(array_merge($_params, ["content" => $content]));
    }

    /**
     * 获取历史搜索词v1
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function listV1 () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->listV1(),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\SearchTerm\SearchTermInfoDTO[]"
        );
    }

    /**
     * 批量删除搜索词v1
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function batchDeleteV1 () {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchDeleteV1();
    }

    /**
     * 删除搜索词v1
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function deleteV1 (string $id, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteV1(array_merge($_params, ["id" => $id]));
    }

    /**
     * 添加搜索词v1
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function createV1 (string $content, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createV1(array_merge($_params, ["content" => $content]));
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}