<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-12-20 20:20:56
 */
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class ShareOrder
 */
class ShareOrder {
    private static string $serviceName = "AppointmentPlatform";

    private static string $className = "Order\\ShareOrder";

    /**
     * 获得买家秀列表
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\ShareOrder\ShareOrderListDTO
    */
    public static function getShareOrderList (int $categoryId, int $page = 1, int $pageSize = 10) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getShareOrderList(["categoryId" => $categoryId, "page" => $page, "pageSize" => $pageSize]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\ShareOrder\ShareOrderListDTO"
        );
    }
    /**
     * 获得晒单类目数据
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\ShareOrder\ShareOrderCategoriesListDTO
    */
    public static function getShareOrderCategories (string $orderNum) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getShareOrderCategories(["orderNum" => $orderNum]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\ShareOrder\ShareOrderCategoriesListDTO"
        );
    }
    /**
     * 提交晒单数据
     * @return  bool
    */
    public static function createShareOrder (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\ShareOrder\ShareOrderCreateCmd $shareOrderCreateCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createShareOrder($shareOrderCreateCmd);
    }
    /**
     * 删除买家秀
     * @return  bool
    */
    public static function deleteShareOrder (int $shareId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteShareOrder(["shareId" => $shareId]);
    }
    /**
     * 获得买家秀列表.V1
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\ShareOrder\ShareOrderListDTO
    */
    public static function getShareOrderListV1 (int $categoryId, int $page = 1, int $pageSize = 10) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getShareOrderListV1(["categoryId" => $categoryId, "page" => $page, "pageSize" => $pageSize]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\ShareOrder\ShareOrderListDTO"
        );
    }
    /**
     * 获得晒单类目数据.v1
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\ShareOrder\ShareOrderCategoriesListDTO
    */
    public static function getShareOrderCategoriesV1 (string $orderNum) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getShareOrderCategoriesV1(["orderNum" => $orderNum]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\ShareOrder\ShareOrderCategoriesListDTO"
        );
    }
    /**
     * 提交晒单数据.V1
     * @return  bool
    */
    public static function createShareOrderV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\ShareOrder\ShareOrderCreateCmd $shareOrderCreateCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createShareOrderV1($shareOrderCreateCmd);
    }
    /**
     * 删除买家秀.v1
     * @return  bool
    */
    public static function deleteShareOrderV1 (int $shareId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteShareOrderV1(["shareId" => $shareId]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}