<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-12-11 17:51:52
 */
namespace Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Reservation;

class MultiReservationListOneDayCmd {
    /**
     * @var  int
     * 城市ID
     * validation: 
     */
    public int $cityId;
    /**
     * @var  array
     * 指定门店列表，会和其他条件获得门店列表做交集,比如:现时购活动门店
     * validation: 
     */
    public array $specialStoreIds = [];
    /**
     * @var  string
     * 门店类型, blue(蓝标)/gold(金标)
     * validation: required|in:blue,gold
     */
    public string $storeType;
    /**
     * @var  null|string
     * 搜索
     * validation: 
     */
    public ?string $searchKey = null;
    /**
     * @var  null|string
     * 用户经纬度
     * validation: 
     */
    public ?string $location = null;
    /**
     * @var  null|string
     * 城市区域,默认为null,区域的中文内容，如：330106000(西湖区)
     * validation: 
     */
    public ?string $cityArea = null;
    /**
     * @var  null|string
     * 拍摄时段,默认为null,4个标签规则互斥,0-24(全部时段)/9-13(13:00以前)/13-17(13:00-17:00)/17-24(17:00以后)
     * validation: sometimes|in:0-24,9-13,13-17,17-24
     */
    public ?string $timeScope = null;
    /**
     * @var  null|string
     * 预约标签,默认为null,5个标签规则互斥, distance(离我最近)/timeSlot(最快可拍)/historyOrder(历史拍过)/appointmentActivity(到店惊喜)/sameStore(同店可拍)
     * validation: sometimes|in:distance,timeSlot,historyOrder,appointmentActivity,sameStore
     */
    public ?string $appointmentLabel = null;
    /**
     * @var  string
     * 查询日期, 格式为:2020-12-12
     * validation: required|date_format:Y-m-d
     */
    public string $date;
    /**
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Reservation\ReservationProductGroupCmd[]
     * 产品数组
     * validation: 
     */
    public array $productGroup;
    /**
     * @var  null|string
     * 订单编号, 修改拍摄时间时传
     * validation: 
     */
    public ?string $orderNum = null;
    /**
     * @var  string
     * 渠道类型，可参考ChannelEnum枚举值【normal 正常的】【limited_time_buy 限时购】
     * validation: 
     */
    public string $channel = "normal";
    /**
     * @var  int
     * 页码, 默认为1
     * validation: 
     */
    public int $page = 1;
    /**
     * @var  int
     * 每页条数, 默认为10
     * validation: 
     */
    public int $pageSize = 10;

    public function __construct (int $cityId = 0, string $storeType = '', string $date = '', array $productGroup = []) {
        if (!is_null($cityId)) {
            $this->cityId = $cityId;
        }
        if (!is_null($storeType)) {
            $this->storeType = $storeType;
        }
        if (!is_null($date)) {
            $this->date = $date;
        }
        if (!is_null($productGroup)) {
            $this->productGroup = $productGroup;
        }
    }

    public static function create(int $cityId = 0, string $storeType = '', string $date = '', array $productGroup = []): self {
        return new self($cityId, $storeType, $date, $productGroup);
    }

    public function setCityId(int $cityId): self {
        $this->cityId = $cityId;

        return $this;
    }

    public function setSpecialStoreIds(array $specialStoreIds): self {
        $this->specialStoreIds = $specialStoreIds;

        return $this;
    }

    public function setStoreType(string $storeType): self {
        $this->storeType = $storeType;

        return $this;
    }

    public function setSearchKey(?string $searchKey): self {
        $this->searchKey = $searchKey;

        return $this;
    }

    public function setLocation(?string $location): self {
        $this->location = $location;

        return $this;
    }

    public function setCityArea(?string $cityArea): self {
        $this->cityArea = $cityArea;

        return $this;
    }

    public function setTimeScope(?string $timeScope): self {
        $this->timeScope = $timeScope;

        return $this;
    }

    public function setAppointmentLabel(?string $appointmentLabel): self {
        $this->appointmentLabel = $appointmentLabel;

        return $this;
    }

    public function setDate(string $date): self {
        $this->date = $date;

        return $this;
    }

    public function setProductGroup(array $productGroup): self {
        $this->productGroup = $productGroup;

        return $this;
    }

    public function setOrderNum(?string $orderNum): self {
        $this->orderNum = $orderNum;

        return $this;
    }

    public function setChannel(string $channel): self {
        $this->channel = $channel;

        return $this;
    }

    public function setPage(int $page): self {
        $this->page = $page;

        return $this;
    }

    public function setPageSize(int $pageSize): self {
        $this->pageSize = $pageSize;

        return $this;
    }
}