<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-11-30 11:21:22
 */
namespace Mainto\Bridge\Invokes\AppointmentPlatform\MessageQueue;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Product
 * @method listenUpdateProductByParams(array $params) 编辑产品通知
 * @method listenUpdateCategoryByParams(array $params) 编辑类目通知
 * @method listenChangeProductWithPriceByParams(array $params) 产品和价格变更通知
 * @method listenChangePriceAreaWithStoreByParams(array $params) 价格区和门店关联变更通知
 * @method listenChangeBlacklistByParams(array $params) 产品禁用门店通知
 */
class Product {
    private static string $serviceName = "AppointmentPlatform";

    private static string $className = "MessageQueue\\Product";

    /**
     * 编辑产品通知
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  int
    */
    public static function listenUpdateProduct (int $productId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->listenUpdateProduct(["productId" => $productId]);
    }

    /**
     * 编辑类目通知
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  int
    */
    public static function listenUpdateCategory (int $categoryId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->listenUpdateCategory(["categoryId" => $categoryId]);
    }

    /**
     * 产品和价格变更通知
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  int
    */
    public static function listenChangeProductWithPrice (int $productId, int $priceId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->listenChangeProductWithPrice(["productId" => $productId, "priceId" => $priceId]);
    }

    /**
     * 价格区和门店关联变更通知
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  int
    */
    public static function listenChangePriceAreaWithStore (array $storeIds, int $priceAreaId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->listenChangePriceAreaWithStore(["storeIds" => $storeIds, "priceAreaId" => $priceAreaId]);
    }

    /**
     * 产品禁用门店通知
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function listenChangeBlacklist (array $productIds, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->listenChangeBlacklist(array_merge($_params, ["productIds" => $productIds]));
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}