<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-11-26 17:03:53
 */
namespace Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order;

class OrderInfoDTO {
    /**
     * @var  int
     * 订单ID
     * validation: 
     */
    public int $orderId;
    /**
     * @var  string
     * 订单单号
     * validation: 
     */
    public string $orderNo;
    /**
     * @var  string
     * 预约拍摄时间
     * validation: 
     */
    public string $reserveTime;
    /**
     * @var  string
     * 订单状态
     * validation: 
     */
    public string $status;
    /**
     * @var  null|string
     * 订单退款状态
     * validation: 
     */
    public ?string $refundStatus = null;
    /**
     * @var  string
     * 订单无纸化状态
     * validation: 
     */
    public string $pendingStatus;
    /**
     * @var  int
     * 修改预约信息次数
     * validation: 
     */
    public int $modifyCount;
    /**
     * @var  bool
     * 是否可以继续修改预约【true 可以继续修改预约时间】【false 不能继续修改预约时间】
     * validation: 
     */
    public bool $canContinueModify;
    /**
     * @var  null|int
     * 订单发票id
     * validation: 
     */
    public ?int $invoiceId = null;
    /**
     * @var  string
     * 订单备注
     * validation: 
     */
    public string $note = "";
    /**
     * @var  bool
     * 是否是重拍订单
     * validation: 
     */
    public bool $isRetakeOrder = false;
    /**
     * @var  string
     * 第一次看片完成类型
     * validation: 
     */
    public string $firstWatchFinishType = "";
    /**
     * @var  string
     * 兑换生日礼遇状态
     * validation: 
     */
    public string $birthGiftStatus;
    /**
     * @var  string
     * 兑换生日礼遇的零售单号
     * validation: 
     */
    public string $birthGiftRetailOrderNo;
    /**
     * @var  bool
     * 是否能晒单
     * validation: 
     */
    public bool $isShare = false;
    /**
     * @var  null|int
     * 分享秀ID
     * validation: 
     */
    public ?int $shareOrderId = null;
    /**
     * @var  string
     * 订单创建时间
     * validation: 
     */
    public string $createdAt = "";
    /**
     * @var  string
     * 订单服务完成时间
     * validation: 
     */
    public string $serviceCompletedAt = "";
    /**
     * @var  string
     * 看片完成类型
     * validation: 
     */
    public string $lookPhotoCompletedType = "";
    /**
     * @var  string
     * 订单来源 pc端 mobile:预约端
     * validation: 
     */
    public string $from = "";
    /**
     * @var  string
     * 订单渠道 具体参考订单中台枚举值 https://doc.pre.hzmantu.com/@/#/doc/Order/dev/enum/OrderChannelEnum
     * validation: 
     */
    public string $orderChannel;
    /**
     * @var  string
     * 订单平台【wechat 微信】【alipay_mini_program 支付宝小程序】【wx_mini_program 微信小程序】【crm_activity CRM】【ios IOS】【android 安卓】【douyin 抖音】【wx_live 微信视频号】
     * validation: 
     */
    public string $platform = "";
    /**
     * @var  null|\Mainto\Bridge\Structs\AppointmentPlatform\DTO\OrderActivity\ActivityInfoDTO
     * 订单活动信息
     * validation: 
     */
    public ?\Mainto\Bridge\Structs\AppointmentPlatform\DTO\OrderActivity\ActivityInfoDTO $activityInfo = null;
    /**
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\User\OrderUserInfoDTO
     * 订单用户信息
     * validation: 
     */
    public \Mainto\Bridge\Structs\AppointmentPlatform\DTO\User\OrderUserInfoDTO $userInfo;
    /**
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\OrderStoreInfoDTO
     * 拍摄门店信息
     * validation: 
     */
    public \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\OrderStoreInfoDTO $storeInfo;
    /**
     * @var  null|\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OrderDiffInfoDTO
     * 订单待支付信息
     * validation: 
     */
    public ?\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OrderDiffInfoDTO $orderDiffInfo = null;
    /**
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\OrderProduct\OrderProductInfoDTO[]
     * 订单产品信息
     * validation: 
     */
    public array $products;
    /**
     * @var  null|\Mainto\Bridge\Structs\AppointmentPlatform\DTO\ShootingBefore\ShootingBeforeChooseDTO
     * 拍前选择
     * validation: 
     */
    public ?\Mainto\Bridge\Structs\AppointmentPlatform\DTO\ShootingBefore\ShootingBeforeChooseDTO $shootingBeforeChoose = null;
    /**
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OrderPaymentInfoDTO
     * 订单支付详情
     * validation: 
     */
    public \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OrderPaymentInfoDTO $paymentInfo;
    /**
     * @var  null|\Mainto\Bridge\Structs\AppointmentPlatform\DTO\AppointmentLookPhoto\LookPhotoInfoDTO
     * 预约看片信息
     * validation: 
     */
    public ?\Mainto\Bridge\Structs\AppointmentPlatform\DTO\AppointmentLookPhoto\LookPhotoInfoDTO $lookPhotoInfo = null;
    /**
     * @var  null|\Mainto\Bridge\Structs\AppointmentPlatform\DTO\RetailOrder\WithRetailOrderDTO
     * 关联的零售订单信息
     * validation: 
     */
    public ?\Mainto\Bridge\Structs\AppointmentPlatform\DTO\RetailOrder\WithRetailOrderDTO $withRetailOrder = null;
    /**
     * @var  bool
     * 是否显示去修修兽按钮
     * validation: 
     */
    public bool $isShowShowPic = false;
    /**
     * @var  bool
     * 是否显示送你修修兽优惠按钮
     * validation: 
     */
    public bool $isShowShowPicPreferential = false;
    /**
     * @var  bool
     * 是否包含魅力职场产品
     * validation: 
     */
    public bool $hasCharmWorkplaceProduct = false;
    /**
     * @var  bool
     * 是否允许转门店 true为可转, false为否
     * validation: 
     */
    public bool $isAllowedChangeStore = false;
    /**
     * @var  string
     * 转门店警示语
     * validation: 
     */
    public string $changeStoreNotice = "";
    /**
     * @var  bool
     * 是否是告白季订单
     * validation: 
     */
    public bool $isConfessionSeasonOrder = false;
    /**
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\MarketingActivity\MarketingActivityInfoDTO[]
     * 活动列表，与同级的activityInfo没有关系，MarketingActivityList主要展示该订单目前可以参与的活动信息
     * validation: 
     */
    public array $marketingActivityList = [];
    /**
     * @var  int
     * 渠道类型，可以参考OrderChannelEnum的枚举值【0 默认】【1 crm活动】【2 其他】
     * validation: 
     */
    public int $channel = 0;
    /**
     * @var  string[]
     * 订单可支付平台，抖音创单抖音支付，非抖音创单非抖音支付
     * validation: 
     */
    public array $canPayPlatform = [];
    /**
     * @var  bool
     * 预约端退款是否需要收取手续费，true表示该订单在历史记录中存在修改时间在24小时内
     * validation: 
     */
    public bool $commissionTag = false;
    /**
     * @var  string
     * 订单模块 see OrderModuleEnum
     * validation: 
     */
    public string $module;
    /**
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OrderSnDTO
     * sn 问卷信息
     * validation: 
     */
    public \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OrderSnDTO $orderSn;
    /**
     * @var  bool
     * 是否显示满意度评价
     * validation: 
     */
    public bool $isShowSatisfactionEvaluation;
    /**
     * @var  string
     * 满意度评价跳转的url
     * validation: 
     */
    public string $satisfactionEvaluationUrl;
    /**
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\LookPhotoConfigDTO
     * 看片相关配置
     * validation: 
     */
    public \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\LookPhotoConfigDTO $lookPhotoConfig;
    /**
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OrderShowInfoDTO
     * 订单展示信息
     * validation: 
     */
    public \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OrderShowInfoDTO $orderShowInfo;
    /**
     * @var  bool
     * 是否需要填写拍摄人信息，true表示需要填写，false表示不需要填写
     * validation: 
     */
    public bool $needPhotographerTag;
    /**
     * @var  bool
     * 是否指派订单，true是，false不是
     * validation: 
     */
    public bool $isAutoAssign;
    /**
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\StandbyTimeDTO[]
     * 候补时间
     * validation: 
     */
    public array $standbyTimeList = [];
    /**
     * @var  string
     * 预约状态，submitted：等待支付, waiting：候补中, success：候补成功, cancel：候补取消, fail：候补失败, normal：普通订单，空为普通订单
     * validation: 
     */
    public string $reserveStatus = "";
    /**
     * @var  string
     * 预约类型，normal或为空：普通预约, standby：候补预约, standbyOversold: 超卖
     * validation: 
     */
    public string $reserveType = "";

    public function __construct (int $orderId = 0, string $orderNo = '', string $reserveTime = '', string $status = '', string $pendingStatus = '', int $modifyCount = 0, bool $canContinueModify = false, string $birthGiftStatus = '', string $birthGiftRetailOrderNo = '', string $orderChannel = '', ?\Mainto\Bridge\Structs\AppointmentPlatform\DTO\User\OrderUserInfoDTO $userInfo = null, ?\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\OrderStoreInfoDTO $storeInfo = null, array $products = [], ?\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OrderPaymentInfoDTO $paymentInfo = null, string $module = '', ?\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OrderSnDTO $orderSn = null, bool $isShowSatisfactionEvaluation = false, string $satisfactionEvaluationUrl = '', ?\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\LookPhotoConfigDTO $lookPhotoConfig = null, ?\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OrderShowInfoDTO $orderShowInfo = null, bool $needPhotographerTag = false, bool $isAutoAssign = false) {
        if (!is_null($orderId)) {
            $this->orderId = $orderId;
        }
        if (!is_null($orderNo)) {
            $this->orderNo = $orderNo;
        }
        if (!is_null($reserveTime)) {
            $this->reserveTime = $reserveTime;
        }
        if (!is_null($status)) {
            $this->status = $status;
        }
        if (!is_null($pendingStatus)) {
            $this->pendingStatus = $pendingStatus;
        }
        if (!is_null($modifyCount)) {
            $this->modifyCount = $modifyCount;
        }
        if (!is_null($canContinueModify)) {
            $this->canContinueModify = $canContinueModify;
        }
        if (!is_null($birthGiftStatus)) {
            $this->birthGiftStatus = $birthGiftStatus;
        }
        if (!is_null($birthGiftRetailOrderNo)) {
            $this->birthGiftRetailOrderNo = $birthGiftRetailOrderNo;
        }
        if (!is_null($orderChannel)) {
            $this->orderChannel = $orderChannel;
        }
        if (!is_null($userInfo)) {
            $this->userInfo = $userInfo;
        }
        if (!is_null($storeInfo)) {
            $this->storeInfo = $storeInfo;
        }
        if (!is_null($products)) {
            $this->products = $products;
        }
        if (!is_null($paymentInfo)) {
            $this->paymentInfo = $paymentInfo;
        }
        if (!is_null($module)) {
            $this->module = $module;
        }
        if (!is_null($orderSn)) {
            $this->orderSn = $orderSn;
        }
        if (!is_null($isShowSatisfactionEvaluation)) {
            $this->isShowSatisfactionEvaluation = $isShowSatisfactionEvaluation;
        }
        if (!is_null($satisfactionEvaluationUrl)) {
            $this->satisfactionEvaluationUrl = $satisfactionEvaluationUrl;
        }
        if (!is_null($lookPhotoConfig)) {
            $this->lookPhotoConfig = $lookPhotoConfig;
        }
        if (!is_null($orderShowInfo)) {
            $this->orderShowInfo = $orderShowInfo;
        }
        if (!is_null($needPhotographerTag)) {
            $this->needPhotographerTag = $needPhotographerTag;
        }
        if (!is_null($isAutoAssign)) {
            $this->isAutoAssign = $isAutoAssign;
        }
    }

    public static function create(int $orderId = 0, string $orderNo = '', string $reserveTime = '', string $status = '', string $pendingStatus = '', int $modifyCount = 0, bool $canContinueModify = false, string $birthGiftStatus = '', string $birthGiftRetailOrderNo = '', string $orderChannel = '', ?\Mainto\Bridge\Structs\AppointmentPlatform\DTO\User\OrderUserInfoDTO $userInfo = null, ?\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\OrderStoreInfoDTO $storeInfo = null, array $products = [], ?\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OrderPaymentInfoDTO $paymentInfo = null, string $module = '', ?\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OrderSnDTO $orderSn = null, bool $isShowSatisfactionEvaluation = false, string $satisfactionEvaluationUrl = '', ?\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\LookPhotoConfigDTO $lookPhotoConfig = null, ?\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OrderShowInfoDTO $orderShowInfo = null, bool $needPhotographerTag = false, bool $isAutoAssign = false): self {
        return new self($orderId, $orderNo, $reserveTime, $status, $pendingStatus, $modifyCount, $canContinueModify, $birthGiftStatus, $birthGiftRetailOrderNo, $orderChannel, $userInfo, $storeInfo, $products, $paymentInfo, $module, $orderSn, $isShowSatisfactionEvaluation, $satisfactionEvaluationUrl, $lookPhotoConfig, $orderShowInfo, $needPhotographerTag, $isAutoAssign);
    }

    public function setOrderId(int $orderId): self {
        $this->orderId = $orderId;

        return $this;
    }

    public function setOrderNo(string $orderNo): self {
        $this->orderNo = $orderNo;

        return $this;
    }

    public function setReserveTime(string $reserveTime): self {
        $this->reserveTime = $reserveTime;

        return $this;
    }

    public function setStatus(string $status): self {
        $this->status = $status;

        return $this;
    }

    public function setRefundStatus(?string $refundStatus): self {
        $this->refundStatus = $refundStatus;

        return $this;
    }

    public function setPendingStatus(string $pendingStatus): self {
        $this->pendingStatus = $pendingStatus;

        return $this;
    }

    public function setModifyCount(int $modifyCount): self {
        $this->modifyCount = $modifyCount;

        return $this;
    }

    public function setCanContinueModify(bool $canContinueModify): self {
        $this->canContinueModify = $canContinueModify;

        return $this;
    }

    public function setInvoiceId(?int $invoiceId): self {
        $this->invoiceId = $invoiceId;

        return $this;
    }

    public function setNote(string $note): self {
        $this->note = $note;

        return $this;
    }

    public function setIsRetakeOrder(bool $isRetakeOrder): self {
        $this->isRetakeOrder = $isRetakeOrder;

        return $this;
    }

    public function setFirstWatchFinishType(string $firstWatchFinishType): self {
        $this->firstWatchFinishType = $firstWatchFinishType;

        return $this;
    }

    public function setBirthGiftStatus(string $birthGiftStatus): self {
        $this->birthGiftStatus = $birthGiftStatus;

        return $this;
    }

    public function setBirthGiftRetailOrderNo(string $birthGiftRetailOrderNo): self {
        $this->birthGiftRetailOrderNo = $birthGiftRetailOrderNo;

        return $this;
    }

    public function setIsShare(bool $isShare): self {
        $this->isShare = $isShare;

        return $this;
    }

    public function setShareOrderId(?int $shareOrderId): self {
        $this->shareOrderId = $shareOrderId;

        return $this;
    }

    public function setCreatedAt(string $createdAt): self {
        $this->createdAt = $createdAt;

        return $this;
    }

    public function setServiceCompletedAt(string $serviceCompletedAt): self {
        $this->serviceCompletedAt = $serviceCompletedAt;

        return $this;
    }

    public function setLookPhotoCompletedType(string $lookPhotoCompletedType): self {
        $this->lookPhotoCompletedType = $lookPhotoCompletedType;

        return $this;
    }

    public function setFrom(string $from): self {
        $this->from = $from;

        return $this;
    }

    public function setOrderChannel(string $orderChannel): self {
        $this->orderChannel = $orderChannel;

        return $this;
    }

    public function setPlatform(string $platform): self {
        $this->platform = $platform;

        return $this;
    }

    public function setActivityInfo(?\Mainto\Bridge\Structs\AppointmentPlatform\DTO\OrderActivity\ActivityInfoDTO $activityInfo): self {
        $this->activityInfo = $activityInfo;

        return $this;
    }

    public function setUserInfo(\Mainto\Bridge\Structs\AppointmentPlatform\DTO\User\OrderUserInfoDTO $userInfo): self {
        $this->userInfo = $userInfo;

        return $this;
    }

    public function setStoreInfo(\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\OrderStoreInfoDTO $storeInfo): self {
        $this->storeInfo = $storeInfo;

        return $this;
    }

    public function setOrderDiffInfo(?\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OrderDiffInfoDTO $orderDiffInfo): self {
        $this->orderDiffInfo = $orderDiffInfo;

        return $this;
    }

    public function setProducts(array $products): self {
        $this->products = $products;

        return $this;
    }

    public function setShootingBeforeChoose(?\Mainto\Bridge\Structs\AppointmentPlatform\DTO\ShootingBefore\ShootingBeforeChooseDTO $shootingBeforeChoose): self {
        $this->shootingBeforeChoose = $shootingBeforeChoose;

        return $this;
    }

    public function setPaymentInfo(\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OrderPaymentInfoDTO $paymentInfo): self {
        $this->paymentInfo = $paymentInfo;

        return $this;
    }

    public function setLookPhotoInfo(?\Mainto\Bridge\Structs\AppointmentPlatform\DTO\AppointmentLookPhoto\LookPhotoInfoDTO $lookPhotoInfo): self {
        $this->lookPhotoInfo = $lookPhotoInfo;

        return $this;
    }

    public function setWithRetailOrder(?\Mainto\Bridge\Structs\AppointmentPlatform\DTO\RetailOrder\WithRetailOrderDTO $withRetailOrder): self {
        $this->withRetailOrder = $withRetailOrder;

        return $this;
    }

    public function setIsShowShowPic(bool $isShowShowPic): self {
        $this->isShowShowPic = $isShowShowPic;

        return $this;
    }

    public function setIsShowShowPicPreferential(bool $isShowShowPicPreferential): self {
        $this->isShowShowPicPreferential = $isShowShowPicPreferential;

        return $this;
    }

    public function setHasCharmWorkplaceProduct(bool $hasCharmWorkplaceProduct): self {
        $this->hasCharmWorkplaceProduct = $hasCharmWorkplaceProduct;

        return $this;
    }

    public function setIsAllowedChangeStore(bool $isAllowedChangeStore): self {
        $this->isAllowedChangeStore = $isAllowedChangeStore;

        return $this;
    }

    public function setChangeStoreNotice(string $changeStoreNotice): self {
        $this->changeStoreNotice = $changeStoreNotice;

        return $this;
    }

    public function setIsConfessionSeasonOrder(bool $isConfessionSeasonOrder): self {
        $this->isConfessionSeasonOrder = $isConfessionSeasonOrder;

        return $this;
    }

    public function setMarketingActivityList(array $marketingActivityList): self {
        $this->marketingActivityList = $marketingActivityList;

        return $this;
    }

    public function setChannel(int $channel): self {
        $this->channel = $channel;

        return $this;
    }

    public function setCanPayPlatform(array $canPayPlatform): self {
        $this->canPayPlatform = $canPayPlatform;

        return $this;
    }

    public function setCommissionTag(bool $commissionTag): self {
        $this->commissionTag = $commissionTag;

        return $this;
    }

    public function setModule(string $module): self {
        $this->module = $module;

        return $this;
    }

    public function setOrderSn(\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OrderSnDTO $orderSn): self {
        $this->orderSn = $orderSn;

        return $this;
    }

    public function setIsShowSatisfactionEvaluation(bool $isShowSatisfactionEvaluation): self {
        $this->isShowSatisfactionEvaluation = $isShowSatisfactionEvaluation;

        return $this;
    }

    public function setSatisfactionEvaluationUrl(string $satisfactionEvaluationUrl): self {
        $this->satisfactionEvaluationUrl = $satisfactionEvaluationUrl;

        return $this;
    }

    public function setLookPhotoConfig(\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\LookPhotoConfigDTO $lookPhotoConfig): self {
        $this->lookPhotoConfig = $lookPhotoConfig;

        return $this;
    }

    public function setOrderShowInfo(\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OrderShowInfoDTO $orderShowInfo): self {
        $this->orderShowInfo = $orderShowInfo;

        return $this;
    }

    public function setNeedPhotographerTag(bool $needPhotographerTag): self {
        $this->needPhotographerTag = $needPhotographerTag;

        return $this;
    }

    public function setIsAutoAssign(bool $isAutoAssign): self {
        $this->isAutoAssign = $isAutoAssign;

        return $this;
    }

    public function setStandbyTimeList(array $standbyTimeList): self {
        $this->standbyTimeList = $standbyTimeList;

        return $this;
    }

    public function setReserveStatus(string $reserveStatus): self {
        $this->reserveStatus = $reserveStatus;

        return $this;
    }

    public function setReserveType(string $reserveType): self {
        $this->reserveType = $reserveType;

        return $this;
    }
}