<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-12-02 13:46:51
 */
namespace Mainto\Bridge\Structs\AppointmentPlatform\Cmd\UndertakePage;

class ProductDeployListCmd {
    /**
     * @var  string
     * 品牌
     * validation: required|in:show_pic,gift_card,himo_retail
     */
    public string $brand;
    /**
     * @var  string
     * 渠道
     * validation: Channel
     */
    public string $channel;
    /**
     * @var  string
     * 分类id
     * validation: sometimes|required_unless:brand,gift_card
     */
    public string $classificationId;
    /**
     * @var  int
     * 页数
     * validation: 
     */
    public int $page = 1;
    /**
     * @var  int
     * 分页数
     * validation: 
     */
    public int $pageSize = 10;

    public function __construct (string $brand = '', string $channel = '', string $classificationId = '') {
        if (!is_null($brand)) {
            $this->brand = $brand;
        }
        if (!is_null($channel)) {
            $this->channel = $channel;
        }
        if (!is_null($classificationId)) {
            $this->classificationId = $classificationId;
        }
    }

    public static function create(string $brand = '', string $channel = '', string $classificationId = ''): self {
        return new self($brand, $channel, $classificationId);
    }

    public function setBrand(string $brand): self {
        $this->brand = $brand;

        return $this;
    }

    public function setChannel(string $channel): self {
        $this->channel = $channel;

        return $this;
    }

    public function setClassificationId(string $classificationId): self {
        $this->classificationId = $classificationId;

        return $this;
    }

    public function setPage(int $page): self {
        $this->page = $page;

        return $this;
    }

    public function setPageSize(int $pageSize): self {
        $this->pageSize = $pageSize;

        return $this;
    }
}