<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-11-20 12:07:02
 */
namespace Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Reservation;

class MultiReservationListOneStoreCmd {
    /**
     * @var  null|string
     * 用户经纬度
     * validation: 
     */
    public ?string $location = null;
    /**
     * @var  int
     * 门店id
     * validation: 
     */
    public int $storeId;
    /**
     * @var  string
     * 开始日期, 如:2023-07-31
     * validation: required|date_format:Y-m-d
     */
    public string $dateStart;
    /**
     * @var  string
     * 结束日期, 如:2023-08-31
     * validation: required|date_format:Y-m-d
     */
    public string $dateEnd;
    /**
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Reservation\ReservationProductGroupCmd[]
     * 产品数组
     * validation: 
     */
    public array $productGroup;
    /**
     * @var  null|string
     * 订单编号, 修改拍摄时间时传
     * validation: 
     */
    public ?string $orderNum = null;
    /**
     * @var  string
     * 渠道类型，可参考ChannelEnum枚举值【normal 正常的】【limited_time_buy 限时购】
     * validation: 
     */
    public string $channel = "normal";
    /**
     * @var  bool
     * 是否是候补【true 为候补场景】【false 非候补场景】
     * validation: 
     */
    public bool $isStandby = false;
    /**
     * @var  null|string
     * 查询类型【standbyOversold 超卖场景】【默认为空 不传不做查询】
     * validation: 
     */
    public ?string $type = "";

    public function __construct (int $storeId = 0, string $dateStart = '', string $dateEnd = '', array $productGroup = []) {
        if (!is_null($storeId)) {
            $this->storeId = $storeId;
        }
        if (!is_null($dateStart)) {
            $this->dateStart = $dateStart;
        }
        if (!is_null($dateEnd)) {
            $this->dateEnd = $dateEnd;
        }
        if (!is_null($productGroup)) {
            $this->productGroup = $productGroup;
        }
    }

    public static function create(int $storeId = 0, string $dateStart = '', string $dateEnd = '', array $productGroup = []): self {
        return new self($storeId, $dateStart, $dateEnd, $productGroup);
    }

    public function setLocation(?string $location): self {
        $this->location = $location;

        return $this;
    }

    public function setStoreId(int $storeId): self {
        $this->storeId = $storeId;

        return $this;
    }

    public function setDateStart(string $dateStart): self {
        $this->dateStart = $dateStart;

        return $this;
    }

    public function setDateEnd(string $dateEnd): self {
        $this->dateEnd = $dateEnd;

        return $this;
    }

    public function setProductGroup(array $productGroup): self {
        $this->productGroup = $productGroup;

        return $this;
    }

    public function setOrderNum(?string $orderNum): self {
        $this->orderNum = $orderNum;

        return $this;
    }

    public function setChannel(string $channel): self {
        $this->channel = $channel;

        return $this;
    }

    public function setIsStandby(bool $isStandby): self {
        $this->isStandby = $isStandby;

        return $this;
    }

    public function setType(?string $type): self {
        $this->type = $type;

        return $this;
    }
}