<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-11-25 09:51:42
 */
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Preferential;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Coupon
 * @method couponListByParams(array $params) 优惠券列表
 * @method multiCouponListByParams(array $params) 多品牌优惠券列表
 * @method receiveCouponByParams(array $params) 领取优惠券
 * @method couponListV1ByParams(array $params) 优惠券列表.v1
 * @method multiCouponListV1ByParams(array $params) 多品牌优惠券列表.v1
 * @method receiveCouponV1ByParams(array $params) 领取优惠券 - v1
 */
class Coupon {
    private static string $serviceName = "AppointmentPlatform";

    private static string $className = "Preferential\\Coupon";

    /**
     * 优惠券列表
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\CouponListDTO
    */
    public static function couponList (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Preferential\CouponListCmd $couponListCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->couponList($couponListCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\CouponListDTO"
        );
    }

    /**
     * 多品牌优惠券列表
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\CouponListDTO
    */
    public static function multiCouponList (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Preferential\MultiCouponListCmd $multiCouponListCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->multiCouponList($multiCouponListCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\CouponListDTO"
        );
    }

    /**
     * 领取优惠券
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\ReceiveCouponDTO
    */
    public static function receiveCoupon (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Preferential\ReceiveCouponCmd $receiveCouponCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->receiveCoupon($receiveCouponCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\ReceiveCouponDTO"
        );
    }

    /**
     * 优惠券列表.v1
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\CouponListDTO
    */
    public static function couponListV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Preferential\CouponListCmd $couponListCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->couponListV1($couponListCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\CouponListDTO"
        );
    }

    /**
     * 多品牌优惠券列表.v1
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\CouponListDTO
    */
    public static function multiCouponListV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Preferential\MultiCouponListCmd $multiCouponListCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->multiCouponListV1($multiCouponListCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\CouponListDTO"
        );
    }

    /**
     * 领取优惠券 - v1
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\ReceiveCouponDTO
    */
    public static function receiveCouponV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Preferential\ReceiveCouponCmd $receiveCouponCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->receiveCouponV1($receiveCouponCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\ReceiveCouponDTO"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}