<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-10-29 17:15:28
 */
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class OrderOther
 * @method encodeGroupOrderDetailByParams(array $params) 获取加密团购订单详情
 * @method encodeRetailOrderDetailByParams(array $params) 获取加密零售订单详情
 * @method encodeOfflineOrderDetailByParams(array $params) 获取加密线下订单详情
 * @method getRetailOrderCodeByParams(array $params) 获取零售订单提货码
 * @method getRetailOrderCodeV1ByParams(array $params) 获取零售订单提货码V1
 */
class OrderOther {
    private static string $serviceName = "AppointmentPlatform";

    private static string $className = "Order\\OrderOther";

    /**
     * 获取加密团购订单详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\GroupOrderDetailDTO
    */
    public static function encodeGroupOrderDetail (string $groupOrderNum) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->encodeGroupOrderDetail(["groupOrderNum" => $groupOrderNum]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\GroupOrderDetailDTO"
        );
    }

    /**
     * 获取加密零售订单详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\RetailOrderDetailDTO
    */
    public static function encodeRetailOrderDetail (string $encodeOrderNum) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->encodeRetailOrderDetail(["encodeOrderNum" => $encodeOrderNum]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\RetailOrderDetailDTO"
        );
    }

    /**
     * 获取加密线下订单详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OfflineOrderDetailDTO
    */
    public static function encodeOfflineOrderDetail (string $encodeOrderNum) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->encodeOfflineOrderDetail(["encodeOrderNum" => $encodeOrderNum]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OfflineOrderDetailDTO"
        );
    }

    /**
     * 获取零售订单提货码
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\MemberRetailProduct\MemberRetailProductExchangeInfoDTO
    */
    public static function getRetailOrderCode (string $orderNo, array $_params = []) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getRetailOrderCode(array_merge($_params, ["orderNo" => $orderNo])),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\MemberRetailProduct\MemberRetailProductExchangeInfoDTO"
        );
    }

    /**
     * 获取零售订单提货码V1
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\MemberRetailProduct\MemberRetailProductExchangeInfoDTO
    */
    public static function getRetailOrderCodeV1 (string $orderNo, array $_params = []) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getRetailOrderCodeV1(array_merge($_params, ["orderNo" => $orderNo])),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\MemberRetailProduct\MemberRetailProductExchangeInfoDTO"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}