<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-11-02 16:41:47
 */
namespace Mainto\Bridge\Structs\AppointmentPlatform\DTO\ShopCart;

class ShopCartProductDTO {
    /**
     * @var  string
     * 购物车id
     * validation: 
     */
    public string $shopCartId;
    /**
     * @var  string
     * 品牌类型，blue/gold
     * validation: 
     */
    public string $module;
    /**
     * @var  int
     * 产品id
     * validation: 
     */
    public int $productId;
    /**
     * @var  int
     * 产品组id
     * validation: 
     */
    public int $categoryId;
    /**
     * @var  int[]
     * 加修加印数量数组
     * validation: 
     */
    public array $jxjyNum = [];
    /**
     * @var  int
     * 拍摄数量
     * validation: 
     */
    public int $num;
    /**
     * @var  int
     * 拍摄人数
     * validation: 
     */
    public int $peopleNum;
    /**
     * @var  null|\Mainto\RpcServer\Util\Types\Map<int, int>
     * 人宠拍摄数据, { 201:4 }
     * validation: 
     */
    public ?\Mainto\RpcServer\Util\Types\Map $counter = null;
    /**
     * @var  bool
     * 是否实体
     * validation: 
     */
    public bool $isEntity;
    /**
     * @var  int
     * 套餐id
     * validation: 
     */
    public int $packageId = 0;
    /**
     * @var  int
     * 子套餐id
     * validation: 
     */
    public int $subPackageId = 0;
    /**
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\ShopCart\ShopCartProductServiceDTO[]
     * 服务数组
     * validation: 
     */
    public array $services = [];
    /**
     * @var  string
     * 创建时间
     * validation: 
     */
    public string $createdAt;
    /**
     * @var  int[]
     * 零售必选产品ids(历史快照数据)
     * validation: 
     */
    public array $retailProductIds;

    public function __construct (string $shopCartId = '', string $module = '', int $productId = 0, int $categoryId = 0, int $num = 0, int $peopleNum = 0, bool $isEntity = false, string $createdAt = '', array $retailProductIds = []) {
        if (!is_null($shopCartId)) {
            $this->shopCartId = $shopCartId;
        }
        if (!is_null($module)) {
            $this->module = $module;
        }
        if (!is_null($productId)) {
            $this->productId = $productId;
        }
        if (!is_null($categoryId)) {
            $this->categoryId = $categoryId;
        }
        if (!is_null($num)) {
            $this->num = $num;
        }
        if (!is_null($peopleNum)) {
            $this->peopleNum = $peopleNum;
        }
        if (!is_null($isEntity)) {
            $this->isEntity = $isEntity;
        }
        if (!is_null($createdAt)) {
            $this->createdAt = $createdAt;
        }
        if (!is_null($retailProductIds)) {
            $this->retailProductIds = $retailProductIds;
        }
    }

    public static function create(string $shopCartId = '', string $module = '', int $productId = 0, int $categoryId = 0, int $num = 0, int $peopleNum = 0, bool $isEntity = false, string $createdAt = '', array $retailProductIds = []): self {
        return new self($shopCartId, $module, $productId, $categoryId, $num, $peopleNum, $isEntity, $createdAt, $retailProductIds);
    }

    public function setShopCartId(string $shopCartId): self {
        $this->shopCartId = $shopCartId;

        return $this;
    }

    public function setModule(string $module): self {
        $this->module = $module;

        return $this;
    }

    public function setProductId(int $productId): self {
        $this->productId = $productId;

        return $this;
    }

    public function setCategoryId(int $categoryId): self {
        $this->categoryId = $categoryId;

        return $this;
    }

    public function setJxjyNum(array $jxjyNum): self {
        $this->jxjyNum = $jxjyNum;

        return $this;
    }

    public function setNum(int $num): self {
        $this->num = $num;

        return $this;
    }

    public function setPeopleNum(int $peopleNum): self {
        $this->peopleNum = $peopleNum;

        return $this;
    }

    public function setCounter(?\Mainto\RpcServer\Util\Types\Map $counter): self {
        $this->counter = $counter;

        return $this;
    }

    public function setIsEntity(bool $isEntity): self {
        $this->isEntity = $isEntity;

        return $this;
    }

    public function setPackageId(int $packageId): self {
        $this->packageId = $packageId;

        return $this;
    }

    public function setSubPackageId(int $subPackageId): self {
        $this->subPackageId = $subPackageId;

        return $this;
    }

    public function setServices(array $services): self {
        $this->services = $services;

        return $this;
    }

    public function setCreatedAt(string $createdAt): self {
        $this->createdAt = $createdAt;

        return $this;
    }

    public function setRetailProductIds(array $retailProductIds): self {
        $this->retailProductIds = $retailProductIds;

        return $this;
    }
}