<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-10-31 12:04:30
 */
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Common;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Config
 * @method hotWordsByParams(array $params) 获取热门搜索
 * @method defaultWordByParams(array $params) 获取默认搜索词
 * @method recommendForYouByParams(array $params) 获取为你推荐
 * @method getConfessionSeasonConfigByParams(array $params) 获取告白季活动配置
 * @method getConfigKeywordByParams(array $params) 获取模块关键词
 * @method getFormContentListByParams(array $params) 获取表单内容列表
 * @method getStyleInfoByParams(array $params) 获取界面风格信息
 * @method hotWordsV1ByParams(array $params) 获取热门搜索v1
 * @method defaultWordV1ByParams(array $params) 获取默认搜索词v1
 * @method recommendForYouV1ByParams(array $params) 获取为你推荐v1
 * @method getConfessionSeasonConfigV1ByParams(array $params) 获取告白季活动配置.v1
 * @method getConfigKeywordV1ByParams(array $params) 获取模块关键词.v1
 * @method getFormContentListV1ByParams(array $params) 获取表单内容列表.v1
 * @method getStyleInfoV1ByParams(array $params) 获取界面风格信息.v1
 */
class Config {
    private static string $serviceName = "AppointmentPlatform";

    private static string $className = "Common\\Config";

    /**
     * 获取热门搜索
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Common\HotWordsDTO
    */
    public static function hotWords () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->hotWords(),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Common\HotWordsDTO"
        );
    }

    /**
     * 获取默认搜索词
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Common\DefaultWordDTO
    */
    public static function defaultWord () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->defaultWord(),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Common\DefaultWordDTO"
        );
    }

    /**
     * 获取为你推荐
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Common\RecommendListDTO
    */
    public static function recommendForYou () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->recommendForYou(),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Common\RecommendListDTO"
        );
    }

    /**
     * 获取告白季活动配置
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\ConfessionSeason\ConfessionSeasonConfigDTO
    */
    public static function getConfessionSeasonConfig () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getConfessionSeasonConfig(),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\ConfessionSeason\ConfessionSeasonConfigDTO"
        );
    }

    /**
     * 获取模块关键词
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Common\ConfigKeywordDTO
    */
    public static function getConfigKeyword (?\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Common\ConfigKeywordCmd $configKeywordCmd = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getConfigKeyword($configKeywordCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Common\ConfigKeywordDTO"
        );
    }

    /**
     * 获取表单内容列表
     * @return  array
    */
    public static function getFormContentList (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Common\FormContentListCmd $formContentListCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getFormContentList($formContentListCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Common\FormContentDTO[]"
        );
    }

    /**
     * 获取界面风格信息
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Common\StyleInfoDTO
    */
    public static function getStyleInfo (?\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Common\StyleInfoCmd $styleInfoCmd = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getStyleInfo($styleInfoCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Common\StyleInfoDTO"
        );
    }

    /**
     * 获取热门搜索v1
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Common\HotWordsDTO
    */
    public static function hotWordsV1 () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->hotWordsV1(),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Common\HotWordsDTO"
        );
    }

    /**
     * 获取默认搜索词v1
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Common\DefaultWordDTO
    */
    public static function defaultWordV1 () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->defaultWordV1(),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Common\DefaultWordDTO"
        );
    }

    /**
     * 获取为你推荐v1
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Common\RecommendListDTO
    */
    public static function recommendForYouV1 () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->recommendForYouV1(),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Common\RecommendListDTO"
        );
    }

    /**
     * 获取告白季活动配置.v1
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\ConfessionSeason\ConfessionSeasonConfigDTO
    */
    public static function getConfessionSeasonConfigV1 () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getConfessionSeasonConfigV1(),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\ConfessionSeason\ConfessionSeasonConfigDTO"
        );
    }

    /**
     * 获取模块关键词.v1
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Common\ConfigKeywordDTO
    */
    public static function getConfigKeywordV1 (?\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Common\ConfigKeywordCmd $configKeywordCmd = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getConfigKeywordV1($configKeywordCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Common\ConfigKeywordDTO"
        );
    }

    /**
     * 获取表单内容列表.v1
     * @return  array
    */
    public static function getFormContentListV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Common\FormContentListCmd $formContentListCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getFormContentListV1($formContentListCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Common\FormContentDTO[]"
        );
    }

    /**
     * 获取界面风格信息.v1
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Common\StyleInfoDTO
    */
    public static function getStyleInfoV1 (?\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Common\StyleInfoCmd $styleInfoCmd = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getStyleInfoV1($styleInfoCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Common\StyleInfoDTO"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}