<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-10-10 11:33:49
 */
namespace Mainto\Bridge\Invokes\AppointmentPlatform\MessageQueue;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class AfterPay
 * @method orderAfterPayByParams(array $params) 拍摄订单,支付完成后的回调 hook
 * @method orderAfterPaySendMessageByParams(array $params) 拍摄订单支付完成后消息推送的hook
 * @method retailOrderAfterPayByParams(array $params) 零售订单,支付完成后的回调 hook
 * @method offlineOrderAfterPayByParams(array $params) 线下订单,支付完成后的回调 hook
 * @method groupOrderAfterPayByParams(array $params) 团购订单,支付完成后的回调 hook
 * @method giftCardOrderAfterPayByParams(array $params) 礼品卡订单,支付完成后的回调 hook
 */
class AfterPay {
    private static string $serviceName = "AppointmentPlatform";

    private static string $className = "MessageQueue\\AfterPay";

    /**
     * 拍摄订单,支付完成后的回调 hook
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function orderAfterPay (string $data, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->orderAfterPay(array_merge($_params, ["data" => $data]));
    }

    /**
     * 拍摄订单支付完成后消息推送的hook
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function orderAfterPaySendMessage (int $orderId, array $orderDiff, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->orderAfterPaySendMessage(array_merge($_params, ["orderId" => $orderId, "orderDiff" => $orderDiff]));
    }

    /**
     * 零售订单,支付完成后的回调 hook
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function retailOrderAfterPay (string $data, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->retailOrderAfterPay(array_merge($_params, ["data" => $data]));
    }

    /**
     * 线下订单,支付完成后的回调 hook
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function offlineOrderAfterPay (string $data, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->offlineOrderAfterPay(array_merge($_params, ["data" => $data]));
    }

    /**
     * 团购订单,支付完成后的回调 hook
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function groupOrderAfterPay (string $data, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->groupOrderAfterPay(array_merge($_params, ["data" => $data]));
    }

    /**
     * 礼品卡订单,支付完成后的回调 hook
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function giftCardOrderAfterPay (string $data, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->giftCardOrderAfterPay(array_merge($_params, ["data" => $data]));
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}