<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-10-11 14:44:18
 */
namespace Mainto\Bridge\Invokes\AppointmentPlatform\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Preferential
 * @method bindPreferentialByParams(array $params) 用户绑定优惠券
 * @method replaceProductCardByParams(array $params) 置换产品卡
 * @method getUserCouponAndProductCardsByParams(array $params) 获取用户可用优惠券和产品卡.无产品ids
 * @method getUserCouponAndProductCardsV1ByParams(array $params) 获取用户可用优惠券和产品卡.v1.无产品ids
 * @method bindPreferentialV1ByParams(array $params) 用户绑定优惠券
 * @method replaceProductCardV1ByParams(array $params) 置换产品卡v1
 */
class Preferential {
    private static string $serviceName = "AppointmentPlatform";

    private static string $className = "User\\Preferential";

    /**
     * 用户绑定优惠券
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\BindPreferentialDTO
    */
    public static function bindPreferential (string $preferentialCode, array $_params = []) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->bindPreferential(array_merge($_params, ["preferentialCode" => $preferentialCode])),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\BindPreferentialDTO"
        );
    }

    /**
     * 置换产品卡
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function replaceProductCard (int $productCardId, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->replaceProductCard(array_merge($_params, ["productCardId" => $productCardId]));
    }

    /**
     * 获取用户可用优惠券和产品卡.无产品ids
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\UserCouponAndProductCardDTO
    */
    public static function getUserCouponAndProductCards () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getUserCouponAndProductCards(),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\UserCouponAndProductCardDTO"
        );
    }

    /**
     * 获取用户可用优惠券和产品卡.v1.无产品ids
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\UserCouponAndProductCardDTO
    */
    public static function getUserCouponAndProductCardsV1 () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getUserCouponAndProductCardsV1(),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\UserCouponAndProductCardDTO"
        );
    }

    /**
     * 用户绑定优惠券
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\BindPreferentialDTO
    */
    public static function bindPreferentialV1 (string $preferentialCode, array $_params = []) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->bindPreferentialV1(array_merge($_params, ["preferentialCode" => $preferentialCode])),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\BindPreferentialDTO"
        );
    }

    /**
     * 置换产品卡v1
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function replaceProductCardV1 (int $productCardId, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->replaceProductCardV1(array_merge($_params, ["productCardId" => $productCardId]));
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}