<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-10-10 16:12:13
 */
namespace Mainto\Bridge\Structs\AppointmentPlatform\Cmd\UserInvoice;

class InvoiceCreateCmd {
    /**
     * @var  string[]
     * 订单号
     * validation: 
     */
    public array $orderNums;
    /**
     * @var  string
     * 服务类型
     * validation: 
     */
    public string $serviceType;
    /**
     * @var  int
     * 是否立即开具电子发票
     * validation: 
     */
    public int $isNow;
    /**
     * @var  string
     * 购方名称
     * validation: 
     */
    public string $name;
    /**
     * @var  string
     * 购方手机，收验证码的手机号
     * validation: required_without:email
     */
    public string $phone;
    /**
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\UserInvoice\InvoiceCreateDetailCmd[]
     * 电子发票明细
     * validation: 
     */
    public array $detail;
    /**
     * @var  string
     * 备注信息
     * validation: 
     */
    public string $message = "";
    /**
     * @var  string
     * 购方税号(18/20位)
     * validation: 
     */
    public string $taxnum = "";
    /**
     * @var  string
     * 推送邮箱
     * validation: required_without:phone
     */
    public string $email;
    /**
     * @var  string
     * 购方电话
     * validation: 
     */
    public string $telephone = "";
    /**
     * @var  string
     * 购方单位地址
     * validation: 
     */
    public string $address = "";
    /**
     * @var  string
     * 购方银行账号(和开户行合在一起)
     * validation: 
     */
    public string $account = "";

    public function __construct (int $userId = 0, array $orderNums = [], string $serviceType = '', int $isNow = 0, string $name = '', string $phone = '', array $detail = [], string $email = '') {
        if (!is_null($userId)) {
            $this->userId = $userId;
        }
        if (!is_null($orderNums)) {
            $this->orderNums = $orderNums;
        }
        if (!is_null($serviceType)) {
            $this->serviceType = $serviceType;
        }
        if (!is_null($isNow)) {
            $this->isNow = $isNow;
        }
        if (!is_null($name)) {
            $this->name = $name;
        }
        if (!is_null($phone)) {
            $this->phone = $phone;
        }
        if (!is_null($detail)) {
            $this->detail = $detail;
        }
        if (!is_null($email)) {
            $this->email = $email;
        }
    }

    public static function create(int $userId = 0, array $orderNums = [], string $serviceType = '', int $isNow = 0, string $name = '', string $phone = '', array $detail = [], string $email = ''): self {
        return new self($userId, $orderNums, $serviceType, $isNow, $name, $phone, $detail, $email);
    }

    public function setOrderNums(array $orderNums): self {
        $this->orderNums = $orderNums;

        return $this;
    }

    public function setServiceType(string $serviceType): self {
        $this->serviceType = $serviceType;

        return $this;
    }

    public function setIsNow(int $isNow): self {
        $this->isNow = $isNow;

        return $this;
    }

    public function setName(string $name): self {
        $this->name = $name;

        return $this;
    }

    public function setPhone(string $phone): self {
        $this->phone = $phone;

        return $this;
    }

    public function setDetail(array $detail): self {
        $this->detail = $detail;

        return $this;
    }

    public function setMessage(string $message): self {
        $this->message = $message;

        return $this;
    }

    public function setTaxnum(string $taxnum): self {
        $this->taxnum = $taxnum;

        return $this;
    }

    public function setEmail(string $email): self {
        $this->email = $email;

        return $this;
    }

    public function setTelephone(string $telephone): self {
        $this->telephone = $telephone;

        return $this;
    }

    public function setAddress(string $address): self {
        $this->address = $address;

        return $this;
    }

    public function setAccount(string $account): self {
        $this->account = $account;

        return $this;
    }
}