<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-06-26 18:15:07
 */
namespace Mainto\Bridge\Invokes\AppointmentPlatform\MessageQueue;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class OrderMessageQueue
 * @method orderCompleteByParams(array $params) 订单完成推送通知
 * @method creatGifImgByParams(array $params) 图片处理
 * @method signSuccessByParams(array $params) 门店签到成功
 * @method sendEvaluateMessageByParams(array $params) 订单非自动看片完成事件,发送评价消息
 * @method afterSaleOrderLookPhotoCompleteByParams(array $params) 售后单二次看片完成事件
 * @method sendAppointmentLookPhotoMessageByParams(array $params) 预约看片成功提醒
 * @method sendPhotographerTagMessageByParams(array $params) 用户记忆-拍摄人信息
 */
class OrderMessageQueue {
    private static string $serviceName = "AppointmentPlatform";

    private static string $className = "MessageQueue\\OrderMessageQueue";

    /**
     * 订单完成推送通知
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function orderComplete (int $orderId, string $watchType, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->orderComplete(array_merge($_params, ["orderId" => $orderId, "watchType" => $watchType]));
    }

    /**
     * 图片处理
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function creatGifImg (string $photoUrl, int $productId, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->creatGifImg(array_merge($_params, ["photoUrl" => $photoUrl, "productId" => $productId]));
    }

    /**
     * 门店签到成功
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function signSuccess (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->signSuccess(array_merge($_params, []));
    }

    /**
     * 订单非自动看片完成事件,发送评价消息
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function sendEvaluateMessage (bool $isRepeatLook = false, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->sendEvaluateMessage(array_merge($_params, ["isRepeatLook" => $isRepeatLook]));
    }

    /**
     * 售后单二次看片完成事件
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function afterSaleOrderLookPhotoComplete (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->afterSaleOrderLookPhotoComplete(array_merge($_params, []));
    }

    /**
     * 预约看片成功提醒
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function sendAppointmentLookPhotoMessage (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->sendAppointmentLookPhotoMessage(array_merge($_params, []));
    }

    /**
     * 用户记忆-拍摄人信息
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function sendPhotographerTagMessage (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->sendPhotographerTagMessage(array_merge($_params, []));
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}