<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-07-01 14:09:36
 */
namespace Mainto\Bridge\Invokes\AppointmentPlatform\MessageQueue;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Order
 * @method sendNormalNotifyByParams(array $params) 看片通知
 * @method listenOrderServiceCompletedByParams(array $params) 监听订单服务完成
 * @method sendOrderRefundAsyncNotifyByParams(array $params) 订单退款通知
 * @method listenOrderCancelByParams(array $params) 取消订单事件监听
 * @method listenOrderPaidOrderByParams(array $params) 监听订单支付事件
 * @method listenOrderStatusUpdateByParams(array $params) 监听订单状态变更事件
 * @method listenOrderLookPhotoByParams(array $params) 监听订单看片完成事件
 * @method listenStandbyOrderSuccessByParams(array $params) 监听候补订单成功
 */
class Order {
    private static string $serviceName = "AppointmentPlatform";

    private static string $className = "MessageQueue\\Order";

    /**
     * 看片通知
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function sendNormalNotify (int $orderId, string $module, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->sendNormalNotify(array_merge($_params, ["orderId" => $orderId, "module" => $module]));
    }

    /**
     * 监听订单服务完成
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function listenOrderServiceCompleted (int $orderId, string $serviceCompleted, array $orderBaseInfo, array $orderSkuList, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->listenOrderServiceCompleted(array_merge($_params, ["orderId" => $orderId, "serviceCompleted" => $serviceCompleted, "orderBaseInfo" => $orderBaseInfo, "orderSkuList" => $orderSkuList]));
    }

    /**
     * 订单退款通知
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function sendOrderRefundAsyncNotify (int $orderId, bool $allRefund, int $refundId, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->sendOrderRefundAsyncNotify(array_merge($_params, ["orderId" => $orderId, "allRefund" => $allRefund, "refundId" => $refundId]));
    }

    /**
     * 取消订单事件监听
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function listenOrderCancel (string $orderNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->listenOrderCancel(["orderNo" => $orderNo]);
    }

    /**
     * 监听订单支付事件
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function listenOrderPaidOrder (int $orderId, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->listenOrderPaidOrder(array_merge($_params, ["orderId" => $orderId]));
    }

    /**
     * 监听订单状态变更事件
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function listenOrderStatusUpdate (int $orderId, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->listenOrderStatusUpdate(array_merge($_params, ["orderId" => $orderId]));
    }

    /**
     * 监听订单看片完成事件
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function listenOrderLookPhoto (int $orderId, string $lookPhotoCompletedAt) {
        return RpcClass::getClass(self::$serviceName, self::$className)->listenOrderLookPhoto(["orderId" => $orderId, "lookPhotoCompletedAt" => $lookPhotoCompletedAt]);
    }

    /**
     * 监听候补订单成功
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function listenStandbyOrderSuccess (string $orderNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->listenStandbyOrderSuccess(["orderNo" => $orderNo]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}