<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-06-10 11:08:41
 */
namespace Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order;

class OrderPayAfterInfoDTO {
    /**
     * @var  int
     * 订单ID
     * validation: 
     */
    public int $orderId;
    /**
     * @var  string
     * 订单单号
     * validation: 
     */
    public string $orderNo;
    /**
     * @var  string
     * 预约拍摄时间
     * validation: 
     */
    public string $reserveTime;
    /**
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\OrderStoreInfoDTO
     * 拍摄门店信息
     * validation: 
     */
    public \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\OrderStoreInfoDTO $storeInfo;
    /**
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\OrderProduct\OrderProductInfoDTO[]
     * 订单产品信息
     * validation: 
     */
    public array $products;
    /**
     * @var  null|\Mainto\Bridge\Structs\AppointmentPlatform\DTO\RetailOrder\WithRetailOrderDTO
     * 关联的零售订单信息
     * validation: 
     */
    public ?\Mainto\Bridge\Structs\AppointmentPlatform\DTO\RetailOrder\WithRetailOrderDTO $withRetailOrder = null;
    /**
     * @var  bool
     * 是否包含魅力职场产品
     * validation: 
     */
    public bool $hasCharmWorkplaceProduct = false;
    /**
     * @var  bool
     * 是否是告白季订单
     * validation: 
     */
    public bool $isConfessionSeasonOrder = false;
    /**
     * @var  bool
     * 是否为缦图引流活动
     * validation: 
     */
    public bool $isMantuRedirectActivity = false;
    /**
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\MarketingActivity\MarketingActivityInfoDTO[]
     * 营销活动列表，与同级的activityInfo没有关系，MarketingActivityList主要展示该订单目前可以参与的营销活动信息
     * validation: 
     */
    public array $marketingActivityList = [];
    /**
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\StandbyTimeDTO[]
     * 候补时间
     * validation: 
     */
    public array $standbyTimeList = [];
    /**
     * @var  string
     * 预约状态，submitted：等待支付, waiting：候补中, success：候补成功, cancel：候补取消, fail：候补失败, normal：普通订单，空为普通订单
     * validation: 
     */
    public string $reserveStatus = "";

    public function __construct (int $orderId = 0, string $orderNo = '', string $reserveTime = '', ?\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\OrderStoreInfoDTO $storeInfo = null, array $products = []) {
        if (!is_null($orderId)) {
            $this->orderId = $orderId;
        }
        if (!is_null($orderNo)) {
            $this->orderNo = $orderNo;
        }
        if (!is_null($reserveTime)) {
            $this->reserveTime = $reserveTime;
        }
        if (!is_null($storeInfo)) {
            $this->storeInfo = $storeInfo;
        }
        if (!is_null($products)) {
            $this->products = $products;
        }
    }

    public static function create(int $orderId = 0, string $orderNo = '', string $reserveTime = '', ?\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\OrderStoreInfoDTO $storeInfo = null, array $products = []): self {
        return new self($orderId, $orderNo, $reserveTime, $storeInfo, $products);
    }

    public function setOrderId(int $orderId): self {
        $this->orderId = $orderId;

        return $this;
    }

    public function setOrderNo(string $orderNo): self {
        $this->orderNo = $orderNo;

        return $this;
    }

    public function setReserveTime(string $reserveTime): self {
        $this->reserveTime = $reserveTime;

        return $this;
    }

    public function setStoreInfo(\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\OrderStoreInfoDTO $storeInfo): self {
        $this->storeInfo = $storeInfo;

        return $this;
    }

    public function setProducts(array $products): self {
        $this->products = $products;

        return $this;
    }

    public function setWithRetailOrder(?\Mainto\Bridge\Structs\AppointmentPlatform\DTO\RetailOrder\WithRetailOrderDTO $withRetailOrder): self {
        $this->withRetailOrder = $withRetailOrder;

        return $this;
    }

    public function setHasCharmWorkplaceProduct(bool $hasCharmWorkplaceProduct): self {
        $this->hasCharmWorkplaceProduct = $hasCharmWorkplaceProduct;

        return $this;
    }

    public function setIsConfessionSeasonOrder(bool $isConfessionSeasonOrder): self {
        $this->isConfessionSeasonOrder = $isConfessionSeasonOrder;

        return $this;
    }

    public function setIsMantuRedirectActivity(bool $isMantuRedirectActivity): self {
        $this->isMantuRedirectActivity = $isMantuRedirectActivity;

        return $this;
    }

    public function setMarketingActivityList(array $marketingActivityList): self {
        $this->marketingActivityList = $marketingActivityList;

        return $this;
    }

    public function setStandbyTimeList(array $standbyTimeList): self {
        $this->standbyTimeList = $standbyTimeList;

        return $this;
    }

    public function setReserveStatus(string $reserveStatus): self {
        $this->reserveStatus = $reserveStatus;

        return $this;
    }
}