<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-06-05 11:18:29
 */
namespace Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Order;

class RefundCreateCmd {
    /**
     * @var  string
     * 订单号
     * validation: 
     */
    public string $orderNo;
    /**
     * @var  array
     * 退款原因ids
     * validation: 
     */
    public array $reasonIds;
    /**
     * @var  string
     * 退款原因
     * validation: sometimes
     */
    public string $reason = "用户退款";
    /**
     * @var  bool
     * 是否为快速退款(退到礼品卡账户)，礼品卡退款值为true，原路退款为false
     * validation: 
     */
    public bool $isFastRefund = true;
    /**
     * @var  string
     * 退款人
     * validation: 
     */
    public string $userName = "";
    /**
     * @var  string
     * 退款支付宝账号
     * validation: 
     */
    public string $userAccount = "";
    /**
     * @var  string
     * 退款平台【wechat 微信/H5】【alipay_mini_program 支付宝小程序】【wx_mini_program 微信小程序】【ios IOS】【android 安卓】【douyin 抖音】【xhs 小红书】
     * validation: sometimes|in:wechat,wx_mini_program,alipay_mini_program,ios,android,wx_app,douyin,xhs
     */
    public string $platform = "";

    public function __construct (string $orderNo = '', array $reasonIds = []) {
        if (!is_null($orderNo)) {
            $this->orderNo = $orderNo;
        }
        if (!is_null($reasonIds)) {
            $this->reasonIds = $reasonIds;
        }
    }

    public static function create(string $orderNo = '', array $reasonIds = []): self {
        return new self($orderNo, $reasonIds);
    }

    public function setOrderNo(string $orderNo): self {
        $this->orderNo = $orderNo;

        return $this;
    }

    public function setReasonIds(array $reasonIds): self {
        $this->reasonIds = $reasonIds;

        return $this;
    }

    public function setReason(string $reason): self {
        $this->reason = $reason;

        return $this;
    }

    public function setIsFastRefund(bool $isFastRefund): self {
        $this->isFastRefund = $isFastRefund;

        return $this;
    }

    public function setUserName(string $userName): self {
        $this->userName = $userName;

        return $this;
    }

    public function setUserAccount(string $userAccount): self {
        $this->userAccount = $userAccount;

        return $this;
    }

    public function setPlatform(string $platform): self {
        $this->platform = $platform;

        return $this;
    }
}