<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-04-02 11:39:27
 */
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class ProductPackage
 * @method packageListByStoreByParams(array $params) 获取某家门店可展示的套餐列表
 * @method packageInfoByParams(array $params) 获取某个套餐的详情信息
 * @method packageListByCategoryByParams(array $params) 获取某些产品组/产品关联的子套餐信息
 * @method getStoreIdsByPackageByParams(array $params) 获取当前城市有哪些门店有当前套餐
 * @method packageListByStoreV1ByParams(array $params) 获取某家门店可展示的套餐列表v1
 * @method packageInfoV1ByParams(array $params) 获取某个套餐的详情信息v1
 * @method packageListByCategoryV1ByParams(array $params) 获取某些产品组/产品关联的子套餐信息v1
 * @method packageListByStoreV2ByParams(array $params) 获取某家门店可展示的套餐列表v2
 */
class ProductPackage {
    private static string $serviceName = "AppointmentPlatform";

    private static string $className = "Product\\ProductPackage";

    /**
     * 获取某家门店可展示的套餐列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function packageListByStore (int $storeId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->packageListByStore(["storeId" => $storeId]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\ProductPackage\ProductPackageDTO[]"
        );
    }

    /**
     * 获取某个套餐的详情信息
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\ProductPackage\ProductPackageDTO
    */
    public static function packageInfo (int $storeId, int $packageId, array $_params = []) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->packageInfo(array_merge($_params, ["storeId" => $storeId, "packageId" => $packageId])),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\ProductPackage\ProductPackageDTO"
        );
    }

    /**
     * 获取某些产品组/产品关联的子套餐信息
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function packageListByCategory (int $storeId, array $ids, array $_params = []) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->packageListByCategory(array_merge($_params, ["storeId" => $storeId, "ids" => $ids])),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\ProductPackage\ProductSubPackageDTO[]"
        );
    }

    /**
     * 获取当前城市有哪些门店有当前套餐
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getStoreIdsByPackage (int $packageId, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreIdsByPackage(array_merge($_params, ["packageId" => $packageId]));
    }

    /**
     * 获取某家门店可展示的套餐列表v1
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function packageListByStoreV1 (int $storeId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->packageListByStoreV1(["storeId" => $storeId]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\ProductPackage\ProductPackageDTO[]"
        );
    }

    /**
     * 获取某个套餐的详情信息v1
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\ProductPackage\ProductPackageDTO
    */
    public static function packageInfoV1 (int $storeId, int $packageId, array $_params = []) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->packageInfoV1(array_merge($_params, ["storeId" => $storeId, "packageId" => $packageId])),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\ProductPackage\ProductPackageDTO"
        );
    }

    /**
     * 获取某些产品组/产品关联的子套餐信息v1
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function packageListByCategoryV1 (int $storeId, array $ids, string $type, array $_params = []) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->packageListByCategoryV1(array_merge($_params, ["storeId" => $storeId, "ids" => $ids, "type" => $type])),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\ProductPackage\ProductSubPackageDTO[]"
        );
    }

    /**
     * 获取某家门店可展示的套餐列表v2
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function packageListByStoreV2 (int $storeId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->packageListByStoreV2(["storeId" => $storeId]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\ProductPackage\ProductPackageDTO[]"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}