<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-03-07 09:55:50
 */
namespace Mainto\Bridge\Invokes\AppointmentPlatform\ShopCart;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class ShopCart
 * @method getMultiMatchPlansByParams(array $params) 获取多家推荐门店.排列组合
 * @method infoByParams(array $params) 获取购物车内容
 * @method saveShopCartByParams(array $params) 加入购物车.新增或者更新
 * @method updateShopCartByParams(array $params) 更新购物车
 * @method deleteShopCartByParams(array $params) 删除购物车所选类目
 * @method getShopCartMarkByParams(array $params) 获取购物车标记
 * @method readShopCartMarkByParams(array $params) 已读购物车标记
 * @method getMultiMatchPlansV1ByParams(array $params) 获取多家推荐门店.排列组合.v1
 * @method infoV1ByParams(array $params) 获取购物车内容.v1
 * @method saveShopCartV1ByParams(array $params) 加入购物车.新增或者更新.v1
 * @method updateShopCartV1ByParams(array $params) 更新购物车.v1
 * @method updateShopCartV2ByParams(array $params) 更新购物车.v2
 * @method deleteShopCartV1ByParams(array $params) 删除购物车所选类目.v1
 * @method getShopCartMarkV1ByParams(array $params) 获取购物车标记.v1
 * @method readShopCartMarkV1ByParams(array $params) 已读购物车标记.v1
 */
class ShopCart {
    private static string $serviceName = "AppointmentPlatform";

    private static string $className = "ShopCart\\ShopCart";

    /**
     * 获取多家推荐门店.排列组合
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\ShopCart\MultiMatchStoreMapDTO
    */
    public static function getMultiMatchPlans (?\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\ShopCart\BestMatchStoresCmd $bestMatchStoresCmd = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getMultiMatchPlans($bestMatchStoresCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\ShopCart\MultiMatchStoreMapDTO"
        );
    }

    /**
     * 获取购物车内容
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\ShopCart\ShopCartInfosDTO
    */
    public static function info (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\ShopCart\ShopCartInfoCmd $shopCartInfoCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->info($shopCartInfoCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\ShopCart\ShopCartInfosDTO"
        );
    }

    /**
     * 加入购物车.新增或者更新
     * @return  bool
    */
    public static function saveShopCart (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\ShopCart\ShopCartSaveCmd $shopCartSaveCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->saveShopCart($shopCartSaveCmd);
    }

    /**
     * 更新购物车
     * @return  bool
    */
    public static function updateShopCart (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\ShopCart\ShopCartUpdateCmd $shopCartUpdateCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateShopCart($shopCartUpdateCmd);
    }

    /**
     * 删除购物车所选类目
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function deleteShopCart (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteShopCart(array_merge($_params, []));
    }

    /**
     * 获取购物车标记
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getShopCartMark () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getShopCartMark();
    }

    /**
     * 已读购物车标记
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function readShopCartMark (string $brand, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->readShopCartMark(array_merge($_params, ["brand" => $brand]));
    }

    /**
     * 获取多家推荐门店.排列组合.v1
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\ShopCart\MultiMatchStoreMapDTO
    */
    public static function getMultiMatchPlansV1 (?\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\ShopCart\BestMatchStoresCmd $bestMatchStoresCmd = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getMultiMatchPlansV1($bestMatchStoresCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\ShopCart\MultiMatchStoreMapDTO"
        );
    }

    /**
     * 获取购物车内容.v1
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\ShopCart\ShopCartInfosDTO
    */
    public static function infoV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\ShopCart\ShopCartInfoCmd $shopCartInfoCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->infoV1($shopCartInfoCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\ShopCart\ShopCartInfosDTO"
        );
    }

    /**
     * 加入购物车.新增或者更新.v1
     * @return  bool
    */
    public static function saveShopCartV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\ShopCart\ShopCartSaveCmd $shopCartSaveCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->saveShopCartV1($shopCartSaveCmd);
    }

    /**
     * 更新购物车.v1
     * @return  bool
    */
    public static function updateShopCartV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\ShopCart\ShopCartUpdateCmd $shopCartUpdateCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateShopCartV1($shopCartUpdateCmd);
    }

    /**
     * 更新购物车.v2
     * @return  bool
    */
    public static function updateShopCartV2 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\ShopCart\ShopCartUpdateCmd $shopCartUpdateCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateShopCartV2($shopCartUpdateCmd);
    }

    /**
     * 删除购物车所选类目.v1
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function deleteShopCartV1 (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteShopCartV1(array_merge($_params, []));
    }

    /**
     * 获取购物车标记.v1
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getShopCartMarkV1 () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getShopCartMarkV1();
    }

    /**
     * 已读购物车标记.v1
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function readShopCartMarkV1 (string $brand, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->readShopCartMarkV1(array_merge($_params, ["brand" => $brand]));
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}