<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-03-07 11:34:19
 */
namespace Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Common;

class WxUrlLinkCmd {
    /**
     * @var  string
     * 应用模块
     * validation: 
     */
    public string $appName;
    /**
     * @var  string
     * 通过 URL Link 进入的小程序页面路径，必须是已经发布的小程序存在的页面，不可携带 query
     * validation: 
     */
    public string $path;
    /**
     * @var  null|string
     * 通过 URL Link 进入小程序时的query，最大1024个字符
     * validation: 
     */
    public ?string $query = null;
    /**
     * @var  null|int
     * 小程序 URL Link 失效类型
     * validation: 
     */
    public ?int $expireType = null;
    /**
     * @var  null|int
     * 到期失效的 URL Link 的失效时间, 为 Unix 时间戳
     * validation: 
     */
    public ?int $expireTime = null;
    /**
     * @var  bool
     * 生成的 URL Link 类型，到期失效：true，永久有效：false。 预约端默认到期失效
     * validation: 
     */
    public bool $isExpire = false;
    /**
     * @var  null|int
     * 到期失效的URL Link的失效间隔天数
     * validation: 
     */
    public ?int $expireInterval = null;
    /**
     * @var  null|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Common\WxUrlLinkCloudBaseCmd
     * 云开发静态网站自定义 H5 配置参数
     * validation: wxMiniUrlLinkCloudBase
     */
    public ?\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Common\WxUrlLinkCloudBaseCmd $cloudBase = null;
    /**
     * @var  string
     * 小程序版本
     * validation: 
     */
    public string $envVersion = "";

    public function __construct (string $appName = '', string $path = '') {
        if (!is_null($appName)) {
            $this->appName = $appName;
        }
        if (!is_null($path)) {
            $this->path = $path;
        }
    }

    public static function create(string $appName = '', string $path = ''): self {
        return new self($appName, $path);
    }

    public function setAppName(string $appName): self {
        $this->appName = $appName;

        return $this;
    }

    public function setPath(string $path): self {
        $this->path = $path;

        return $this;
    }

    public function setQuery(?string $query): self {
        $this->query = $query;

        return $this;
    }

    public function setExpireType(?int $expireType): self {
        $this->expireType = $expireType;

        return $this;
    }

    public function setExpireTime(?int $expireTime): self {
        $this->expireTime = $expireTime;

        return $this;
    }

    public function setIsExpire(bool $isExpire): self {
        $this->isExpire = $isExpire;

        return $this;
    }

    public function setExpireInterval(?int $expireInterval): self {
        $this->expireInterval = $expireInterval;

        return $this;
    }

    public function setCloudBase(?\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Common\WxUrlLinkCloudBaseCmd $cloudBase): self {
        $this->cloudBase = $cloudBase;

        return $this;
    }

    public function setEnvVersion(string $envVersion): self {
        $this->envVersion = $envVersion;

        return $this;
    }
}