<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-12-26 14:51:30
 */
namespace Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential;

class BindPreferentialDTO {
    /**
     * @var  string
     * 券类型: productCard 产品卡, coupon 优惠券
     * validation: 
     */
    public string $cardType;
    /**
     * @var  null|\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\ProductCardDTO
     * 产品卡信息
     * validation: 
     */
    public ?\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\ProductCardDTO $productCardInfo = null;
    /**
     * @var  null|\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\CouponDTO
     * 优惠券信息
     * validation: 
     */
    public ?\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\CouponDTO $couponInfo = null;
    /**
     * @var  bool
     * 是否为直播专享赠券
     * validation: 
     */
    public bool $isGiftCoupons;
    /**
     * @var  string
     * 券码内容图片地址
     * validation: 
     */
    public string $couponImg = "";
    /**
     * @var  string
     * 券码返回信息
     * validation: 
     */
    public string $couponMsg = "兑换成功";

    public function __construct (string $cardType = '', bool $isGiftCoupons = false) {
        if (!is_null($cardType)) {
            $this->cardType = $cardType;
        }
        if (!is_null($isGiftCoupons)) {
            $this->isGiftCoupons = $isGiftCoupons;
        }
    }

    public static function create(string $cardType = '', bool $isGiftCoupons = false): self {
        return new self($cardType, $isGiftCoupons);
    }

    public function setCardType(string $cardType): self {
        $this->cardType = $cardType;

        return $this;
    }

    public function setProductCardInfo(?\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\ProductCardDTO $productCardInfo): self {
        $this->productCardInfo = $productCardInfo;

        return $this;
    }

    public function setCouponInfo(?\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\CouponDTO $couponInfo): self {
        $this->couponInfo = $couponInfo;

        return $this;
    }

    public function setIsGiftCoupons(bool $isGiftCoupons): self {
        $this->isGiftCoupons = $isGiftCoupons;

        return $this;
    }

    public function setCouponImg(string $couponImg): self {
        $this->couponImg = $couponImg;

        return $this;
    }

    public function setCouponMsg(string $couponMsg): self {
        $this->couponMsg = $couponMsg;

        return $this;
    }
}