<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-10-23 14:33:38
 */
namespace Mainto\Bridge\Invokes\AppointmentPlatform\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Notify
 * @method getInvisibleCaptchaV1ByParams(array $params) [腾讯]无痕验证.v1
 * @method getSmsCodeWithInvisibleV1ByParams(array $params) 通过无痕验证后发送短信验证码.v1 最近调用时间在21年12月
 * @method getGeeTestRegisterByParams(array $params) 极验初始化验证
 * @method getGeeTestValidateByParams(array $params) 二次验证
 * @method getSmsCodeByTokenByParams(array $params) 根据token发送短信验证码
 * @method getSmsCodeByTokenV1ByParams(array $params) 根据token发送验证码
 * @method getGeeTestRegisterV1ByParams(array $params) 极验初始化验证/v1
 * @method getGeeTestValidateV1ByParams(array $params) 二次验证/v1
 * @method getSubscribeWxAppNotifyListByParams(array $params) 获取订阅微信app通知的信息
 * @method isSubscribeWxAppNotifyByParams(array $params) 是否已经订阅微信app通知
 * @method subscribeWxAppNotifyByParams(array $params) 订阅微信app通知
 */
class Notify {
    private static string $serviceName = "AppointmentPlatform";

    private static string $className = "User\\Notify";

    /**
     * [腾讯]无痕验证.v1
     * @return  string
    */
    public static function getInvisibleCaptchaV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Notify\InvisibleCaptchaCmd $invisibleCaptchaCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getInvisibleCaptchaV1($invisibleCaptchaCmd);
    }

    /**
     * 通过无痕验证后发送短信验证码.v1 最近调用时间在21年12月
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  string
    */
    public static function getSmsCodeWithInvisibleV1 (string $type = 'haimati_sms_code', string $phone, string $token) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSmsCodeWithInvisibleV1(["type" => $type, "phone" => $phone, "token" => $token]);
    }

    /**
     * 极验初始化验证
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Notify\GeeTestRegisterDTO
    */
    public static function getGeeTestRegister () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getGeeTestRegister([]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Notify\GeeTestRegisterDTO"
        );
    }

    /**
     * 二次验证
     * @return  string
    */
    public static function getGeeTestValidate (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Notify\GeeTestValidateCmd $geeTestValidateCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getGeeTestValidate($geeTestValidateCmd);
    }

    /**
     * 根据token发送短信验证码
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function getSmsCodeByToken (string $type, string $token) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSmsCodeByToken(["type" => $type, "token" => $token]);
    }

    /**
     * 根据token发送验证码
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function getSmsCodeByTokenV1 (string $type, string $token) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSmsCodeByTokenV1(["type" => $type, "token" => $token]);
    }

    /**
     * 极验初始化验证/v1
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Notify\GeeTestRegisterDTO
    */
    public static function getGeeTestRegisterV1 () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getGeeTestRegisterV1([]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Notify\GeeTestRegisterDTO"
        );
    }

    /**
     * 二次验证/v1
     * @return  string
    */
    public static function getGeeTestValidateV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Notify\GeeTestValidateCmd $geeTestValidateCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getGeeTestValidateV1($geeTestValidateCmd);
    }

    /**
     * 获取订阅微信app通知的信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getSubscribeWxAppNotifyList (array $events) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getSubscribeWxAppNotifyList(["events" => $events]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\User\SubscribeMessageEventDTO[]"
        );
    }

    /**
     * 是否已经订阅微信app通知
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function isSubscribeWxAppNotify (string $event) {
        return RpcClass::getClass(self::$serviceName, self::$className)->isSubscribeWxAppNotify(["event" => $event]);
    }

    /**
     * 订阅微信app通知
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function subscribeWxAppNotify (int $userId, string $event) {
        return RpcClass::getClass(self::$serviceName, self::$className)->subscribeWxAppNotify(["userId" => $userId, "event" => $event]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}