<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-09-30 14:46:48
 */
namespace Mainto\Bridge\Invokes\AppointmentPlatform\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class User
 * @method detailByParams(array $params) 用户详情[crm也在使用]
 * @method editUserInfoByParams(array $params) 修改用户信息
 * @method editUserTagByParams(array $params) 修改用户标签
 * @method getProfessionsByParams(array $params) 职业列表[crm也在使用]
 * @method getPreferencesByParams(array $params) 偏好列表
 * @method checkSignByParams(array $params) 绑定邮箱校验是否通过验证
 * @method setProtocolVersionByParams(array $params) 记录预约协议版本
 * @method feedbackByParams(array $params) 用户意见反馈
 * @method changePasswordDirectByParams(array $params) 更改密码（密码为空）
 * @method forgetUserPasswordByParams(array $params) 通过验证码更改登录密码
 * @method cancelByParams(array $params) 注销帐号.old
 * @method searchUserByUnionIdByParams(array $params) 通过unionId判断用户是否在海马体平台注册过
 * @method changUserPasswordByParams(array $params) 更改密码
 * @method closeByParams(array $params) 注销帐号.new
 * @method simplyDetailByParams(array $params) 获取用户ID
 * @method detailV1ByParams(array $params) 用户详情.v1
 * @method editUserInfoV1ByParams(array $params) 修改用户信息.v1
 * @method editUserTagV1ByParams(array $params) 修改用户标签.v1
 * @method getProfessionsV1ByParams(array $params) 职业列表.v1
 * @method getPreferencesV1ByParams(array $params) 偏好列表.v1
 * @method setProtocolVersionV1ByParams(array $params) 记录预约协议版本.v1
 * @method feedbackV1ByParams(array $params) 用户意见反馈.v1
 * @method changePasswordDirectV1ByParams(array $params) 更改密码（密码为空）.v1
 * @method forgetUserPasswordV1ByParams(array $params) 通过验证码更改登录密码.v1
 * @method changUserPasswordV1ByParams(array $params) 更改密码.v1
 * @method cancelV1ByParams(array $params) 注销帐号.v1
 * @method closeV1ByParams(array $params) 注销帐号.new.v1
 */
class User {
    private static string $serviceName = "AppointmentPlatform";

    private static string $className = "User\\User";

    /**
     * 用户详情[crm也在使用]
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\User\UserDetailDTO
    */
    public static function detail () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->detail(),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\User\UserDetailDTO"
        );
    }

    /**
     * 修改用户信息
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\User\UserDetailDTO
    */
    public static function editUserInfo (?\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\User\EditUserInfoCmd $editUserInfoCmd = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->editUserInfo($editUserInfoCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\User\UserDetailDTO"
        );
    }

    /**
     * 修改用户标签
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\User\UserDetailDTO
    */
    public static function editUserTag (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\User\EditUserTagCmd $editUserTagCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->editUserTag($editUserTagCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\User\UserDetailDTO"
        );
    }

    /**
     * 职业列表[crm也在使用]
     * @return  array
    */
    public static function getProfessions () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getProfessions(),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Profession\ProfessionInfoDTO[]"
        );
    }

    /**
     * 偏好列表
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preference\PreferenceListDTO
    */
    public static function getPreferences () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getPreferences(),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preference\PreferenceListDTO"
        );
    }

    /**
     * 绑定邮箱校验是否通过验证
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function checkSign (string $brand, int $user_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkSign(["brand" => $brand, "user_id" => $user_id]);
    }

    /**
     * 记录预约协议版本
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function setProtocolVersion (int $protocolVersion, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setProtocolVersion(array_merge($_params, ["protocolVersion" => $protocolVersion]));
    }

    /**
     * 用户意见反馈
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function feedback (string $content, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->feedback(array_merge($_params, ["content" => $content]));
    }

    /**
     * 更改密码（密码为空）
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function changePasswordDirect (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changePasswordDirect(array_merge($_params, []));
    }

    /**
     * 通过验证码更改登录密码
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function forgetUserPassword (string $phone, string $password, string $captcha) {
        return RpcClass::getClass(self::$serviceName, self::$className)->forgetUserPassword(["phone" => $phone, "password" => $password, "captcha" => $captcha]);
    }

    /**
     * 注销帐号.old
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function cancel () {
        return RpcClass::getClass(self::$serviceName, self::$className)->cancel();
    }

    /**
     * 通过unionId判断用户是否在海马体平台注册过
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function searchUserByUnionId (string $unionId, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->searchUserByUnionId(array_merge($_params, ["unionId" => $unionId]));
    }

    /**
     * 更改密码
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function changUserPassword (string $password, string $passwordNew, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changUserPassword(array_merge($_params, ["password" => $password, "passwordNew" => $passwordNew]));
    }

    /**
     * 注销帐号.new
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\User\CloseMessageDTO
    */
    public static function close () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->close(),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\User\CloseMessageDTO"
        );
    }

    /**
     * 获取用户ID
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\User\UserSimplyDetailDTO
    */
    public static function simplyDetail () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->simplyDetail(),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\User\UserSimplyDetailDTO"
        );
    }

    /**
     * 用户详情.v1
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\User\UserDetailDTO
    */
    public static function detailV1 () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->detailV1(),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\User\UserDetailDTO"
        );
    }

    /**
     * 修改用户信息.v1
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\User\UserDetailDTO
    */
    public static function editUserInfoV1 (?\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\User\EditUserInfoCmd $editUserInfoCmd = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->editUserInfoV1($editUserInfoCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\User\UserDetailDTO"
        );
    }

    /**
     * 修改用户标签.v1
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\User\UserDetailDTO
    */
    public static function editUserTagV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\User\EditUserTagCmd $editUserTagCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->editUserTagV1($editUserTagCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\User\UserDetailDTO"
        );
    }

    /**
     * 职业列表.v1
     * @return  array
    */
    public static function getProfessionsV1 () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getProfessionsV1(),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Profession\ProfessionInfoDTO[]"
        );
    }

    /**
     * 偏好列表.v1
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preference\PreferenceListDTO
    */
    public static function getPreferencesV1 () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getPreferencesV1(),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preference\PreferenceListDTO"
        );
    }

    /**
     * 记录预约协议版本.v1
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function setProtocolVersionV1 (int $protocolVersion, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setProtocolVersionV1(array_merge($_params, ["protocolVersion" => $protocolVersion]));
    }

    /**
     * 用户意见反馈.v1
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function feedbackV1 (string $content, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->feedbackV1(array_merge($_params, ["content" => $content]));
    }

    /**
     * 更改密码（密码为空）.v1
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function changePasswordDirectV1 (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changePasswordDirectV1(array_merge($_params, []));
    }

    /**
     * 通过验证码更改登录密码.v1
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function forgetUserPasswordV1 (string $phone, string $password, string $captcha) {
        return RpcClass::getClass(self::$serviceName, self::$className)->forgetUserPasswordV1(["phone" => $phone, "password" => $password, "captcha" => $captcha]);
    }

    /**
     * 更改密码.v1
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function changUserPasswordV1 (string $password, string $passwordNew, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changUserPasswordV1(array_merge($_params, ["password" => $password, "passwordNew" => $passwordNew]));
    }

    /**
     * 注销帐号.v1
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function cancelV1 () {
        return RpcClass::getClass(self::$serviceName, self::$className)->cancelV1();
    }

    /**
     * 注销帐号.new.v1
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\User\CloseMessageDTO
    */
    public static function closeV1 () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->closeV1(),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\User\CloseMessageDTO"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}