<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-10-16 18:13:30
 */
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Store;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Store
 * @method getCitiesByStoreTypeByParams(array $params) 获取当前有门店的所有城市
 * @method getStoreListByCityIdByParams(array $params) 根据城市id获取门店列表[crm也在使用]
 * @method getStoreInfoByParams(array $params) 根据门店id获取门店详情
 * @method getStoreIdsHaveSameProductByParams(array $params) 获取有该产品的门店ids
 * @method getStoreIdsHaveSameProductByCityIdByParams(array $params) 获取指定城市下拥有指定产品或类目的门店Ids
 * @method getStoreIdsHaveSameCategoryByParams(array $params) 获取当前城市包含这个类目 中 任意 产品的门店ids
 * @method getStoreListByIdsByParams(array $params) 根据门店ids获取门店信息
 * @method getMostNearestStoreByParams(array $params) 获取距离最近的门店[crm也在使用]
 * @method getStoreTypesByParams(array $params) 获取门店tab类型
 * @method getAggregationStoreInfoByStoreIdByParams(array $params) 获取某个门店的产品、套餐树
 * @method getCitiesByStoreTypeV1ByParams(array $params) 获取当前有门店的所有城市.v1
 * @method getStoreListByCityIdV1ByParams(array $params) 根据城市id获取门店列表.v1
 * @method getStoreInfoV1ByParams(array $params) 根据门店id获取门店详情.v1
 * @method getStoreTypesV1ByParams(array $params) 获取门店tab类型v1
 * @method getAggregationStoreInfoByStoreIdV1ByParams(array $params) 获取某个门店的产品、套餐树
 * @method getCitiesByStoreTypeV2ByParams(array $params) 获取当前有门店的所有城市.v2
 * @method getStoreListByCityIdV2ByParams(array $params) 根据城市id获取门店列表.v2
 */
class Store {
    private static string $serviceName = "AppointmentPlatform";

    private static string $className = "Store\\Store";

    /**
     * 获取当前有门店的所有城市
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getCitiesByStoreType (array $_params = []) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getCitiesByStoreType(array_merge($_params, [])),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\CityStoreDTO[]"
        );
    }

    /**
     * 根据城市id获取门店列表[crm也在使用]
     * @return  array
    */
    public static function getStoreListByCityId (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Store\GetStoreListByCityIdCmd $getStoreListByCityIdCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getStoreListByCityId($getStoreListByCityIdCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\StoreAdvancedInfoDTO[]"
        );
    }

    /**
     * 根据门店id获取门店详情
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\StoreBaseInfoDTO
    */
    public static function getStoreInfo (int $storeId, array $_params = []) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getStoreInfo(array_merge($_params, ["storeId" => $storeId])),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\StoreBaseInfoDTO"
        );
    }

    /**
     * 获取有该产品的门店ids
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getStoreIdsHaveSameProduct (array $productIds, array $storeIds, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreIdsHaveSameProduct(array_merge($_params, ["productIds" => $productIds, "storeIds" => $storeIds]));
    }

    /**
     * 获取指定城市下拥有指定产品或类目的门店Ids
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getStoreIdsHaveSameProductByCityId (int $nodeId, string $type, int $cityId, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreIdsHaveSameProductByCityId(array_merge($_params, ["nodeId" => $nodeId, "type" => $type, "cityId" => $cityId]));
    }

    /**
     * 获取当前城市包含这个类目 中 任意 产品的门店ids
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getStoreIdsHaveSameCategory (int $categoryId, int $cityId, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreIdsHaveSameCategory(array_merge($_params, ["categoryId" => $categoryId, "cityId" => $cityId]));
    }

    /**
     * 根据门店ids获取门店信息
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getStoreListByIds (array $storeIds, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreListByIds(array_merge($_params, ["storeIds" => $storeIds]));
    }

    /**
     * 获取距离最近的门店[crm也在使用]
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\StoreAdvancedInfoDTO
    */
    public static function getMostNearestStore (array $location, string $brand) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getMostNearestStore(["location" => $location, "brand" => $brand]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\StoreAdvancedInfoDTO"
        );
    }

    /**
     * 获取门店tab类型
     * @return  array
    */
    public static function getStoreTypes () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getStoreTypes(),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\StoreTypeDTO[]"
        );
    }

    /**
     * 获取某个门店的产品、套餐树
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\AggregationStoreInfoDTO
    */
    public static function getAggregationStoreInfoByStoreId (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Store\AggregationStoreInfoByStoreIdCmd $aggregationStoreInfoByStoreIdCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getAggregationStoreInfoByStoreId($aggregationStoreInfoByStoreIdCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\AggregationStoreInfoDTO"
        );
    }

    /**
     * 获取当前有门店的所有城市.v1
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getCitiesByStoreTypeV1 (array $_params = []) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getCitiesByStoreTypeV1(array_merge($_params, [])),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\CityStoreDTO[]"
        );
    }

    /**
     * 根据城市id获取门店列表.v1
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getStoreListByCityIdV1 (array $cityIds, array $_params = []) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getStoreListByCityIdV1(array_merge($_params, ["cityIds" => $cityIds])),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\StoreAdvancedInfoDTO[]"
        );
    }

    /**
     * 根据门店id获取门店详情.v1
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\StoreBaseInfoDTO
    */
    public static function getStoreInfoV1 (int $storeId, array $_params = []) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getStoreInfoV1(array_merge($_params, ["storeId" => $storeId])),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\StoreBaseInfoDTO"
        );
    }

    /**
     * 获取门店tab类型v1
     * @return  array
    */
    public static function getStoreTypesV1 () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getStoreTypesV1(),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\StoreTypeDTO[]"
        );
    }

    /**
     * 获取某个门店的产品、套餐树
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\AggregationStoreInfoDTO
    */
    public static function getAggregationStoreInfoByStoreIdV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Store\AggregationStoreInfoByStoreIdCmd $aggregationStoreInfoByStoreIdCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getAggregationStoreInfoByStoreIdV1($aggregationStoreInfoByStoreIdCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\AggregationStoreInfoDTO"
        );
    }

    /**
     * 获取当前有门店的所有城市.v2
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getCitiesByStoreTypeV2 (array $_params = []) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getCitiesByStoreTypeV2(array_merge($_params, [])),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\CityStoreDTO[]"
        );
    }

    /**
     * 根据城市id获取门店列表.v2
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getStoreListByCityIdV2 (array $cityIds, string $type = 'advanced', array $_params = []) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getStoreListByCityIdV2(array_merge($_params, ["cityIds" => $cityIds, "type" => $type])),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Store\StoreAdvancedInfoDTO[]"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}