<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-08-08 15:38:37
 */
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Product
 * @method getProductDetailInStoreByParams(array $params) 获取产品详情.需门店
 * @method getAllProductsByParams(array $params) 获取所有产品
 * @method productTreeByParams(array $params) 获取某个门店的产品树
 * @method getCategoryProductsByStoreIdByParams(array $params) 获取一个门店下某个类目所有的产品[crm也在使用]
 * @method categoriesByParams(array $params) 根据类目ids获取类目
 * @method haveCategoryStoreIdsByParams(array $params) 过滤出有该类目的门店ids
 * @method getProductGiftRuleByParams(array $params) 获取赠品规则
 * @method productSearchByParams(array $params) 产品搜索
 * @method checkProductCouldOccupyByParams(array $params) 校验产品占点
 * @method getAllProductsV1ByParams(array $params) 获取所有产品.v1
 * @method productTreeV1ByParams(array $params) 获取某个门店的产品树v1
 * @method categoriesV1ByParams(array $params) 根据类目ids获取类目.v1
 * @method getCategoryProductsByStoreIdV1ByParams(array $params) 获取一个门店下某个类目所有的产品.v1
 * @method productSearchV1ByParams(array $params) 产品搜索v1
 * @method checkProductCouldOccupyV1ByParams(array $params) 校验产品占点v1
 * @method getProductYouLikeV2ByParams(array $params) 获得猜你喜欢.v2
 * @method productTreeV2ByParams(array $params) 获取某个门店的产品树v2
 * @method getCategoryProductsByStoreIdV2ByParams(array $params) 获取一个门店下某个类目所有的产品.v2
 * @method productTreeV3ByParams(array $params) 获取某个门店的产品树v3
 */
class Product {
    private static string $serviceName = "AppointmentPlatform";

    private static string $className = "Product\\Product";

    /**
     * 获取产品详情.需门店
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ProductBaseWithGroupServicesAndPriceAndGonggeDTO
    */
    public static function getProductDetailInStore (int $storeId, int $productId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getProductDetailInStore(["storeId" => $storeId, "productId" => $productId]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ProductBaseWithGroupServicesAndPriceAndGonggeDTO"
        );
    }

    /**
     * 获取所有产品
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getAllProducts (int $storeId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAllProducts(["storeId" => $storeId]);
    }

    /**
     * 获取某个门店的产品树
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function productTree (int $storeId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->productTree(["storeId" => $storeId]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ProductTreeSeriesDTO[]"
        );
    }

    /**
     * 获取一个门店下某个类目所有的产品[crm也在使用]
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ProductCategoryBaseWithChildrenDTO
    */
    public static function getCategoryProductsByStoreId (int $storeId, int $categoryId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getCategoryProductsByStoreId(["storeId" => $storeId, "categoryId" => $categoryId]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ProductCategoryBaseWithChildrenDTO"
        );
    }

    /**
     * 根据类目ids获取类目
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function categories (array $categoryIds, int $cityId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->categories(["categoryIds" => $categoryIds, "cityId" => $cityId]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ProductCategoryBaseWithChildrenDTO[]"
        );
    }

    /**
     * 过滤出有该类目的门店ids
     * @return  array
    */
    public static function haveCategoryStoreIds (?\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Product\SameNodeStoreIdsCmd $sameNodeStoreIdsCmd = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->haveCategoryStoreIds($sameNodeStoreIdsCmd);
    }

    /**
     * 获取赠品规则
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getProductGiftRule (int $nodeId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getProductGiftRule(["nodeId" => $nodeId]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\GiftRule\GiftRuleDTO[]"
        );
    }

    /**
     * 产品搜索
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\SearchCategory\SearchModuleDTO
    */
    public static function productSearch (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Product\ProductSearchCmd $productSearchCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->productSearch($productSearchCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\SearchCategory\SearchModuleDTO"
        );
    }

    /**
     * 校验产品占点
     * @return  bool
    */
    public static function checkProductCouldOccupy (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Product\CheckProductCouldOccupyCmd $checkProductCouldOccupyCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkProductCouldOccupy($checkProductCouldOccupyCmd);
    }

    /**
     * 获取所有产品.v1
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getAllProductsV1 (int $storeId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAllProductsV1(["storeId" => $storeId]);
    }

    /**
     * 获取某个门店的产品树v1
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function productTreeV1 (int $storeId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->productTreeV1(["storeId" => $storeId]);
    }

    /**
     * 根据类目ids获取类目.v1
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function categoriesV1 (array $categoryIds, int $cityId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->categoriesV1(["categoryIds" => $categoryIds, "cityId" => $cityId]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ProductCategoryBaseWithChildrenDTO[]"
        );
    }

    /**
     * 获取一个门店下某个类目所有的产品.v1
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ProductCategoryBaseWithChildrenDTO
    */
    public static function getCategoryProductsByStoreIdV1 (int $storeId, int $categoryId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getCategoryProductsByStoreIdV1(["storeId" => $storeId, "categoryId" => $categoryId]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ProductCategoryBaseWithChildrenDTO"
        );
    }

    /**
     * 产品搜索v1
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\SearchCategory\SearchModuleDTO
    */
    public static function productSearchV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Product\ProductSearchCmd $productSearchCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->productSearchV1($productSearchCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\SearchCategory\SearchModuleDTO"
        );
    }

    /**
     * 校验产品占点v1
     * @return  bool
    */
    public static function checkProductCouldOccupyV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Product\CheckProductCouldOccupyCmd $checkProductCouldOccupyCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkProductCouldOccupyV1($checkProductCouldOccupyCmd);
    }

    /**
     * 获得猜你喜欢.v2
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getProductYouLikeV2 () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductYouLikeV2([]);
    }

    /**
     * 获取某个门店的产品树v2
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function productTreeV2 (int $storeId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->productTreeV2(["storeId" => $storeId]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ProductTreeSeriesDTO[]"
        );
    }

    /**
     * 获取一个门店下某个类目所有的产品.v2
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ProductCategoryBaseWithChildrenDTO
    */
    public static function getCategoryProductsByStoreIdV2 (int $storeId, int $categoryId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getCategoryProductsByStoreIdV2(["storeId" => $storeId, "categoryId" => $categoryId]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ProductCategoryBaseWithChildrenDTO"
        );
    }

    /**
     * 获取某个门店的产品树v3
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function productTreeV3 (int $storeId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->productTreeV3(["storeId" => $storeId]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\ProductTreeSeriesDTO[]"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}