<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-07-24 16:15:38
 */
namespace Mainto\Bridge\Invokes\AppointmentPlatform\OrderNew;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class CharmWorkplace
 * @method getCharmWorkplaceConfigByParams(array $params) 获取职场魅力配置信息
 * @method submitCharmWorkplaceByParams(array $params) 提交职场魅力
 * @method getOrderCharmWorkplaceByParams(array $params) 获取订单职场魅力信息
 * @method changeCharmWorkplaceByParams(array $params) 编辑职场魅力
 */
class CharmWorkplace {
    private static string $serviceName = "AppointmentPlatform";

    private static string $className = "OrderNew\\CharmWorkplace";

    /**
     * 获取职场魅力配置信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\CharmWorkplaceDTO
    */
    public static function getCharmWorkplaceConfig (string $module) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getCharmWorkplaceConfig(["module" => $module]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Product\CharmWorkplaceDTO"
        );
    }

    /**
     * 提交职场魅力
     * @return  bool
    */
    public static function submitCharmWorkplace (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Order\SubmitCharmWorkplaceCmd $submitCharmWorkplaceCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->submitCharmWorkplace($submitCharmWorkplaceCmd);
    }

    /**
     * 获取订单职场魅力信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OrderCharmWorkplaceDTO
    */
    public static function getOrderCharmWorkplace (int $orderId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getOrderCharmWorkplace(["orderId" => $orderId]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OrderCharmWorkplaceDTO"
        );
    }

    /**
     * 编辑职场魅力
     * @return  bool
    */
    public static function changeCharmWorkplace (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Order\EditCharmWorkplaceCmd $editCharmWorkplaceCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changeCharmWorkplace($editCharmWorkplaceCmd);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}