<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-08-25 11:43:35
 */
namespace Mainto\Bridge\Structs\AppointmentPlatform\Cmd\RetailOrder;

class RetailOrderRefundCmd {
    /**
     * @var  int
     * 海马体订单id
     * validation: 
     */
    public int $orderId;
    /**
     * @var  string
     * 零售订单编号
     * validation: 
     */
    public string $retailOrderNo;
    /**
     * @var  int
     * 门店id
     * validation: 
     */
    public int $storeId;
    /**
     * @var  string
     * 退款原因
     * validation: 
     */
    public string $refundReason;
    /**
     * @var  string
     * 退款人姓名
     * validation: 
     */
    public string $userName;
    /**
     * @var  string
     * 退款人支付宝账户
     * validation: 
     */
    public string $userAccount;
    /**
     * @var  string
     * （待废弃）退款渠道,【wechat 微信/H5】【alipay_mini_program 支付宝小程序】【wx_mini_program 微信小程序】【ios IOS】【android 安卓】【douyin 抖音】
     * validation: sometimes|in:wechat,wx_mini_program,alipay_mini_program,ios,android,wx_app,douyin
     */
    public string $channel = "";
    /**
     * @var  string
     * 退款平台【wechat 微信/H5】【alipay_mini_program 支付宝小程序】【wx_mini_program 微信小程序】【ios IOS】【android 安卓】【douyin 抖音】
     * validation: sometimes|in:wechat,wx_mini_program,alipay_mini_program,ios,android,wx_app,douyin
     */
    public string $platform = "";

    public function __construct (int $currentUserId = 0, int $orderId = 0, string $retailOrderNo = '', int $storeId = 0, string $refundReason = '', string $userName = '', string $userAccount = '') {
        if (!is_null($currentUserId)) {
            $this->currentUserId = $currentUserId;
        }
        if (!is_null($orderId)) {
            $this->orderId = $orderId;
        }
        if (!is_null($retailOrderNo)) {
            $this->retailOrderNo = $retailOrderNo;
        }
        if (!is_null($storeId)) {
            $this->storeId = $storeId;
        }
        if (!is_null($refundReason)) {
            $this->refundReason = $refundReason;
        }
        if (!is_null($userName)) {
            $this->userName = $userName;
        }
        if (!is_null($userAccount)) {
            $this->userAccount = $userAccount;
        }
    }

    public static function create(int $currentUserId = 0, int $orderId = 0, string $retailOrderNo = '', int $storeId = 0, string $refundReason = '', string $userName = '', string $userAccount = ''): self {
        return new self($currentUserId, $orderId, $retailOrderNo, $storeId, $refundReason, $userName, $userAccount);
    }

    public function setOrderId(int $orderId): self {
        $this->orderId = $orderId;

        return $this;
    }

    public function setRetailOrderNo(string $retailOrderNo): self {
        $this->retailOrderNo = $retailOrderNo;

        return $this;
    }

    public function setStoreId(int $storeId): self {
        $this->storeId = $storeId;

        return $this;
    }

    public function setRefundReason(string $refundReason): self {
        $this->refundReason = $refundReason;

        return $this;
    }

    public function setUserName(string $userName): self {
        $this->userName = $userName;

        return $this;
    }

    public function setUserAccount(string $userAccount): self {
        $this->userAccount = $userAccount;

        return $this;
    }

    public function setChannel(string $channel): self {
        $this->channel = $channel;

        return $this;
    }

    public function setPlatform(string $platform): self {
        $this->platform = $platform;

        return $this;
    }
}