<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-09-03 15:19:56
 */
namespace Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Reservation;

class MultiReservationListByPageCmd {
    /**
     * @var  int[]
     * 门店ids
     * validation: 
     */
    public array $storeIds;
    /**
     * @var  null|string
     * 门店名称-支持模糊
     * validation: 
     */
    public ?string $storeName = null;
    /**
     * @var  string
     * 当前开始时间,当天内
     * validation: required|date_format:Y-m-d H:i
     */
    public string $dateStart;
    /**
     * @var  string
     * 当前结束时间,当天内
     * validation: required|date_format:Y-m-d H:i
     */
    public string $dateEnd;
    /**
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Reservation\ReservationProductGroupCmd[]
     * 产品数组
     * validation: 
     */
    public array $productGroup;
    /**
     * @var  null|string
     * 订单编号 修改拍摄时间时传
     * validation: 
     */
    public ?string $orderNum = null;
    /**
     * @var  int
     * 页码
     * validation: 
     */
    public int $page = 1;
    /**
     * @var  int
     * 每页条数
     * validation: 
     */
    public int $pageSize = 10;
    /**
     * @var  string
     * 渠道类型，可参考ChannelEnum枚举值【normal 正常的】【limited_time_buy 限时购】
     * validation: 
     */
    public string $channel = "normal";
    /**
     * @var  int
     * 城市ID
     * validation: 
     */
    public int $cityId = 0;
    /**
     * @var  null|string
     * 门店类型 【blue 蓝标】【gold 大师】
     * validation: 
     */
    public ?string $storeType = null;

    public function __construct (array $storeIds = [], string $dateStart = '', string $dateEnd = '', array $productGroup = []) {
        if (!is_null($storeIds)) {
            $this->storeIds = $storeIds;
        }
        if (!is_null($dateStart)) {
            $this->dateStart = $dateStart;
        }
        if (!is_null($dateEnd)) {
            $this->dateEnd = $dateEnd;
        }
        if (!is_null($productGroup)) {
            $this->productGroup = $productGroup;
        }
    }

    public static function create(array $storeIds = [], string $dateStart = '', string $dateEnd = '', array $productGroup = []): self {
        return new self($storeIds, $dateStart, $dateEnd, $productGroup);
    }

    public function setStoreIds(array $storeIds): self {
        $this->storeIds = $storeIds;

        return $this;
    }

    public function setStoreName(?string $storeName): self {
        $this->storeName = $storeName;

        return $this;
    }

    public function setDateStart(string $dateStart): self {
        $this->dateStart = $dateStart;

        return $this;
    }

    public function setDateEnd(string $dateEnd): self {
        $this->dateEnd = $dateEnd;

        return $this;
    }

    public function setProductGroup(array $productGroup): self {
        $this->productGroup = $productGroup;

        return $this;
    }

    public function setOrderNum(?string $orderNum): self {
        $this->orderNum = $orderNum;

        return $this;
    }

    public function setPage(int $page): self {
        $this->page = $page;

        return $this;
    }

    public function setPageSize(int $pageSize): self {
        $this->pageSize = $pageSize;

        return $this;
    }

    public function setChannel(string $channel): self {
        $this->channel = $channel;

        return $this;
    }

    public function setCityId(int $cityId): self {
        $this->cityId = $cityId;

        return $this;
    }

    public function setStoreType(?string $storeType): self {
        $this->storeType = $storeType;

        return $this;
    }
}