<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-07-12 15:02:36
 */
namespace Mainto\Bridge\Structs\AppointmentPlatform\DTO\Activity;

class ActivityCommonDTO {
    /**
     * @var  string
     * 活动的类型，CRM没有活动ID，所以需要用活动类型作为唯一标识，可以参考ActivityTypeEnum的枚举值【graduation_gift 毕业大礼包】【mantu_redirect 缦图引流】【retail_redirect 零售引流】【gold_retail_redirect 大师X零售引流】【blue_redirect 蓝标引流（职业形象照入口引流）】【appointment_mark 预约活动打标】
     * validation: 
     */
    public string $activityType;
    /**
     * @var  string
     * 活动名称
     * validation: 
     */
    public string $activityName;
    /**
     * @var  string
     * 活动场景，参考ActivitySceneEnum枚举值
     * validation: 
     */
    public string $activityScene = "normal";
    /**
     * @var  int
     * 排序值
     * validation: 
     */
    public int $sort;
    /**
     * @var  null|string
     * 活动的开始时间，时间格式为 Y-m-d H:i:s, 如果为null表示该活动一直在进行
     * validation: 
     */
    public ?string $startAt;
    /**
     * @var  null|string
     * 活动的结束时间，时间格式为 Y-m-d H:i:s, 如果为null表示该活动不会结束
     * validation: 
     */
    public ?string $endAt;
    /**
     * @var  string
     * 对于该活动下的订单状态，可参考OrderActivityStatusEnum枚举值【wait_receive 未领取】【received 已领取】
     * validation: 
     */
    public string $orderActivityStatus;
    /**
     * @var  null|\Mainto\Bridge\Structs\AppointmentPlatform\DTO\MarketingActivity\MarketingActivityElementInfoDTO
     * 需要在前端页面里展示出来的元素信息
     * validation: 
     */
    public ?\Mainto\Bridge\Structs\AppointmentPlatform\DTO\MarketingActivity\MarketingActivityElementInfoDTO $element;
    /**
     * @var  null|string
     * 用户点击后需要上报给神策埋点的数据，json数据
     * validation: 
     */
    public ?string $reportData = null;

    public function __construct (string $activityType = '', string $activityName = '', int $sort = 0, ?string $startAt = '', ?string $endAt = '', string $orderActivityStatus = '', ?\Mainto\Bridge\Structs\AppointmentPlatform\DTO\MarketingActivity\MarketingActivityElementInfoDTO $element = null) {
        if (!is_null($activityType)) {
            $this->activityType = $activityType;
        }
        if (!is_null($activityName)) {
            $this->activityName = $activityName;
        }
        if (!is_null($sort)) {
            $this->sort = $sort;
        }
        if (!is_null($startAt)) {
            $this->startAt = $startAt;
        }
        if (!is_null($endAt)) {
            $this->endAt = $endAt;
        }
        if (!is_null($orderActivityStatus)) {
            $this->orderActivityStatus = $orderActivityStatus;
        }
        if (!is_null($element)) {
            $this->element = $element;
        }
    }

    public static function create(string $activityType = '', string $activityName = '', int $sort = 0, ?string $startAt = '', ?string $endAt = '', string $orderActivityStatus = '', ?\Mainto\Bridge\Structs\AppointmentPlatform\DTO\MarketingActivity\MarketingActivityElementInfoDTO $element = null): self {
        return new self($activityType, $activityName, $sort, $startAt, $endAt, $orderActivityStatus, $element);
    }

    public function setActivityType(string $activityType): self {
        $this->activityType = $activityType;

        return $this;
    }

    public function setActivityName(string $activityName): self {
        $this->activityName = $activityName;

        return $this;
    }

    public function setActivityScene(string $activityScene): self {
        $this->activityScene = $activityScene;

        return $this;
    }

    public function setSort(int $sort): self {
        $this->sort = $sort;

        return $this;
    }

    public function setStartAt(?string $startAt): self {
        $this->startAt = $startAt;

        return $this;
    }

    public function setEndAt(?string $endAt): self {
        $this->endAt = $endAt;

        return $this;
    }

    public function setOrderActivityStatus(string $orderActivityStatus): self {
        $this->orderActivityStatus = $orderActivityStatus;

        return $this;
    }

    public function setElement(?\Mainto\Bridge\Structs\AppointmentPlatform\DTO\MarketingActivity\MarketingActivityElementInfoDTO $element): self {
        $this->element = $element;

        return $this;
    }

    public function setReportData(?string $reportData): self {
        $this->reportData = $reportData;

        return $this;
    }
}