<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-08-27 16:59:58
 */
namespace Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order;

class RefundDTO {
    /**
     * @var  float
     * 允许退款的总金额，单位：元, 后端已做了计算
     * validation: 
     */
    public float $realAllowRefundMoney;
    /**
     * @var  bool
     * 是否能直接退款, true为能直接退款, false需要填写退款帐号
     * validation: 
     */
    public bool $refundDirect;
    /**
     * @var  int
     * 退款费率，默认15，即15%
     * validation: 
     */
    public int $refundRate;
    /**
     * @var  int
     * 退款提示变更时间节点，默认48，即48h
     * validation: 
     */
    public int $refundChangeTime;
    /**
     * @var  int
     * 最大退款金额，默认300
     * validation: 
     */
    public int $refundMaxMoney;
    /**
     * @var  bool
     * 需要扣除手续费, 是否有在预约时间24小时内
     * validation: 
     */
    public bool $commissionTag;
    /**
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OrderInfoDTO
     * 
     * validation: 
     */
    public \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OrderInfoDTO $orderInfo;
    /**
     * @var  float
     * 退款时手续费金额，单位：元
     * validation: 
     */
    public float $serviceCommissionMoney;
    /**
     * @var  float
     * 退款的现金金额，单位：元
     * validation: 
     */
    public float $refundCashMoney;
    /**
     * @var  float
     * 退款的礼品卡金额，单位：元
     * validation: 
     */
    public float $refundGiftCardMoney;
    /**
     * @var  string
     * 聚合订单号 目前仅抖音渠道返回值
     * validation: 
     */
    public string $aggregateOrderNo;
    /**
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\DouyinItemOrderDTO[]
     * 抖音退款信息
     * validation: 
     */
    public array $douyinItemOrders;

    public function __construct (float $realAllowRefundMoney = 0.0, bool $refundDirect = false, int $refundRate = 0, int $refundChangeTime = 0, int $refundMaxMoney = 0, bool $commissionTag = false, ?\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OrderInfoDTO $orderInfo = null, float $serviceCommissionMoney = 0.0, float $refundCashMoney = 0.0, float $refundGiftCardMoney = 0.0, string $aggregateOrderNo = '', array $douyinItemOrders = []) {
        if (!is_null($realAllowRefundMoney)) {
            $this->realAllowRefundMoney = $realAllowRefundMoney;
        }
        if (!is_null($refundDirect)) {
            $this->refundDirect = $refundDirect;
        }
        if (!is_null($refundRate)) {
            $this->refundRate = $refundRate;
        }
        if (!is_null($refundChangeTime)) {
            $this->refundChangeTime = $refundChangeTime;
        }
        if (!is_null($refundMaxMoney)) {
            $this->refundMaxMoney = $refundMaxMoney;
        }
        if (!is_null($commissionTag)) {
            $this->commissionTag = $commissionTag;
        }
        if (!is_null($orderInfo)) {
            $this->orderInfo = $orderInfo;
        }
        if (!is_null($serviceCommissionMoney)) {
            $this->serviceCommissionMoney = $serviceCommissionMoney;
        }
        if (!is_null($refundCashMoney)) {
            $this->refundCashMoney = $refundCashMoney;
        }
        if (!is_null($refundGiftCardMoney)) {
            $this->refundGiftCardMoney = $refundGiftCardMoney;
        }
        if (!is_null($aggregateOrderNo)) {
            $this->aggregateOrderNo = $aggregateOrderNo;
        }
        if (!is_null($douyinItemOrders)) {
            $this->douyinItemOrders = $douyinItemOrders;
        }
    }

    public static function create(float $realAllowRefundMoney = 0.0, bool $refundDirect = false, int $refundRate = 0, int $refundChangeTime = 0, int $refundMaxMoney = 0, bool $commissionTag = false, ?\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OrderInfoDTO $orderInfo = null, float $serviceCommissionMoney = 0.0, float $refundCashMoney = 0.0, float $refundGiftCardMoney = 0.0, string $aggregateOrderNo = '', array $douyinItemOrders = []): self {
        return new self($realAllowRefundMoney, $refundDirect, $refundRate, $refundChangeTime, $refundMaxMoney, $commissionTag, $orderInfo, $serviceCommissionMoney, $refundCashMoney, $refundGiftCardMoney, $aggregateOrderNo, $douyinItemOrders);
    }

    public function setRealAllowRefundMoney(float $realAllowRefundMoney): self {
        $this->realAllowRefundMoney = $realAllowRefundMoney;

        return $this;
    }

    public function setRefundDirect(bool $refundDirect): self {
        $this->refundDirect = $refundDirect;

        return $this;
    }

    public function setRefundRate(int $refundRate): self {
        $this->refundRate = $refundRate;

        return $this;
    }

    public function setRefundChangeTime(int $refundChangeTime): self {
        $this->refundChangeTime = $refundChangeTime;

        return $this;
    }

    public function setRefundMaxMoney(int $refundMaxMoney): self {
        $this->refundMaxMoney = $refundMaxMoney;

        return $this;
    }

    public function setCommissionTag(bool $commissionTag): self {
        $this->commissionTag = $commissionTag;

        return $this;
    }

    public function setOrderInfo(\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Order\OrderInfoDTO $orderInfo): self {
        $this->orderInfo = $orderInfo;

        return $this;
    }

    public function setServiceCommissionMoney(float $serviceCommissionMoney): self {
        $this->serviceCommissionMoney = $serviceCommissionMoney;

        return $this;
    }

    public function setRefundCashMoney(float $refundCashMoney): self {
        $this->refundCashMoney = $refundCashMoney;

        return $this;
    }

    public function setRefundGiftCardMoney(float $refundGiftCardMoney): self {
        $this->refundGiftCardMoney = $refundGiftCardMoney;

        return $this;
    }

    public function setAggregateOrderNo(string $aggregateOrderNo): self {
        $this->aggregateOrderNo = $aggregateOrderNo;

        return $this;
    }

    public function setDouyinItemOrders(array $douyinItemOrders): self {
        $this->douyinItemOrders = $douyinItemOrders;

        return $this;
    }
}