<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-06-30 16:19:30
 */
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Common;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Common
 * @method checkIdentifyTextContentByParams(array $params) 校验文本信息
 * @method getServerTimeByParams(array $params) 获取当前服务器时间
 * @method checkIdentifyTextContentV1ByParams(array $params) 校验文本信息.v1
 * @method sendAppPushByParams(array $params) 发送App消息
 * @method getServerTimeV1ByParams(array $params) 获取当前服务器时间.v1
 */
class Common {
    private static string $serviceName = "AppointmentPlatform";

    private static string $className = "Common\\Common";

    /**
     * 校验文本信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function checkIdentifyTextContent (array $content) {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkIdentifyTextContent(["content" => $content]);
    }

    /**
     * 获取当前服务器时间
     * @return  int
    */
    public static function getServerTime () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getServerTime();
    }

    /**
     * 校验文本信息.v1
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function checkIdentifyTextContentV1 (array $content) {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkIdentifyTextContentV1(["content" => $content]);
    }

    /**
     * 发送App消息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function sendAppPush (int $userId, string $title, string $content) {
        return RpcClass::getClass(self::$serviceName, self::$className)->sendAppPush(["userId" => $userId, "title" => $title, "content" => $content]);
    }

    /**
     * 获取当前服务器时间.v1
     * @return  int
    */
    public static function getServerTimeV1 () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getServerTimeV1();
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}