<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-07-03 17:56:24
 */
namespace Mainto\Bridge\Invokes\AppointmentPlatform\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class PhotoAlbum
 * @method listPhotoAlbumsByParams(array $params) 我的相册
 * @method createSharePhotoRecordByParams(array $params) 相册分享记录.创建
 * @method updateSharePhotoRecordByParams(array $params) 相册分享记录.更新
 * @method getShareRecordDetailByParams(array $params) 分享记录详情
 * @method saveSharePhotosByParams(array $params) 保存分享数据到我的相册
 * @method getPictureMeasureByParams(array $params) 获取照片裁剪尺寸信息
 * @method getPictureTypeByParams(array $params) 获得图片类型
 * @method deleteSharePhotoByParams(array $params) 删除共享的照片
 * @method listPhotoAlbumsV1ByParams(array $params) 我的相册.v1
 * @method createSharePhotoRecordV1ByParams(array $params) 相册分享记录.创建.v1
 * @method getShareRecordDetailV1ByParams(array $params) 分享记录详情.v1
 * @method saveSharePhotosV1ByParams(array $params) 保存分享数据到我的相册.v1
 * @method getPictureTypeV1ByParams(array $params) 获得图片类型.v1
 * @method getPictureMeasureV1ByParams(array $params) 获取照片裁剪尺寸信息v1
 * @method deleteSharePhotoV1ByParams(array $params) 删除共享的照片
 */
class PhotoAlbum {
    private static string $serviceName = "AppointmentPlatform";

    private static string $className = "User\\PhotoAlbum";

    /**
     * 我的相册
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\PhotoAlbum\PhotoAlbumListDTO
    */
    public static function listPhotoAlbums (int $page = 1, int $pageSize = 10) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->listPhotoAlbums(["page" => $page, "pageSize" => $pageSize]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\PhotoAlbum\PhotoAlbumListDTO"
        );
    }

    /**
     * 相册分享记录.创建
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\PhotoAlbum\CreateSharePhotoRecordDTO
    */
    public static function createSharePhotoRecord (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\SharePhotoRecord\CreateSharePhotoRecordCmd $createSharePhotoRecordCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->createSharePhotoRecord($createSharePhotoRecordCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\PhotoAlbum\CreateSharePhotoRecordDTO"
        );
    }

    /**
     * 相册分享记录.更新
     * @return  bool
    */
    public static function updateSharePhotoRecord (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\SharePhotoRecord\UpdateSharePhotoRecordCmd $updateSharePhotoRecordCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateSharePhotoRecord($updateSharePhotoRecordCmd);
    }

    /**
     * 分享记录详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\PhotoAlbum\SharePhotoRecordDetailDTO
    */
    public static function getShareRecordDetail (string $shareRecordId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getShareRecordDetail(["shareRecordId" => $shareRecordId]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\PhotoAlbum\SharePhotoRecordDetailDTO"
        );
    }

    /**
     * 保存分享数据到我的相册
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\PhotoAlbum\SaveSharePhotosDTO
    */
    public static function saveSharePhotos (string $shareRecordId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->saveSharePhotos(["shareRecordId" => $shareRecordId]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\PhotoAlbum\SaveSharePhotosDTO"
        );
    }

    /**
     * 获取照片裁剪尺寸信息
     * @return  array
    */
    public static function getPictureMeasure () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getPictureMeasure(),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\PhotoAlbum\PictureMeasureDetailDTO[]"
        );
    }

    /**
     * 获得图片类型
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  string
    */
    public static function getPictureType (string $orderNum, string $photoVersionId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPictureType(["orderNum" => $orderNum, "photoVersionId" => $photoVersionId]);
    }

    /**
     * 删除共享的照片
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function deleteSharePhoto (string $orderNum) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteSharePhoto(["orderNum" => $orderNum]);
    }

    /**
     * 我的相册.v1
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\PhotoAlbum\PhotoAlbumListDTO
    */
    public static function listPhotoAlbumsV1 (int $page = 1, int $pageSize = 10) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->listPhotoAlbumsV1(["page" => $page, "pageSize" => $pageSize]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\PhotoAlbum\PhotoAlbumListDTO"
        );
    }

    /**
     * 相册分享记录.创建.v1
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\PhotoAlbum\CreateSharePhotoRecordDTO
    */
    public static function createSharePhotoRecordV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\SharePhotoRecord\CreateSharePhotoRecordCmd $createSharePhotoRecordCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->createSharePhotoRecordV1($createSharePhotoRecordCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\PhotoAlbum\CreateSharePhotoRecordDTO"
        );
    }

    /**
     * 分享记录详情.v1
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\PhotoAlbum\SharePhotoRecordDetailDTO
    */
    public static function getShareRecordDetailV1 (string $shareRecordId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getShareRecordDetailV1(["shareRecordId" => $shareRecordId]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\PhotoAlbum\SharePhotoRecordDetailDTO"
        );
    }

    /**
     * 保存分享数据到我的相册.v1
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\PhotoAlbum\SaveSharePhotosDTO
    */
    public static function saveSharePhotosV1 (string $shareRecordId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->saveSharePhotosV1(["shareRecordId" => $shareRecordId]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\PhotoAlbum\SaveSharePhotosDTO"
        );
    }

    /**
     * 获得图片类型.v1
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  string
    */
    public static function getPictureTypeV1 (string $orderNum, string $photoVersionId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPictureTypeV1(["orderNum" => $orderNum, "photoVersionId" => $photoVersionId]);
    }

    /**
     * 获取照片裁剪尺寸信息v1
     * @return  array
    */
    public static function getPictureMeasureV1 () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getPictureMeasureV1(),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\PhotoAlbum\PictureMeasureDetailDTO[]"
        );
    }

    /**
     * 删除共享的照片
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function deleteSharePhotoV1 (string $orderNum) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteSharePhotoV1(["orderNum" => $orderNum]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}