<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-07-04 17:41:33
 */
namespace Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Reservation;

class MultiReservationStateCmd {
    /**
     * @var  array
     * 门店id列表
     * validation: 
     */
    public array $storeIds = [];
    /**
     * @var  string
     * 门店类型, blue(蓝标)/gold(金标)
     * validation: in:blue,gold
     */
    public string $storeType = "";
    /**
     * @var  int
     * 城市ID
     * validation: 
     */
    public int $cityId = 0;
    /**
     * @var  string
     * 开始日期,如： 2023-09-01
     * validation: required|date_format:Y-m-d
     */
    public string $dateStart;
    /**
     * @var  string
     * 结束日期, 如： 2023-10-01
     * validation: required|date_format:Y-m-d
     */
    public string $dateEnd;
    /**
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Reservation\ReservationProductGroupCmd[]
     * 产品数组
     * validation: 
     */
    public array $productGroup;
    /**
     * @var  null|string
     * 订单编号, 修改拍摄时间时传
     * validation: 
     */
    public ?string $orderNum = null;

    public function __construct (string $dateStart = '', string $dateEnd = '', array $productGroup = []) {
        if (!is_null($dateStart)) {
            $this->dateStart = $dateStart;
        }
        if (!is_null($dateEnd)) {
            $this->dateEnd = $dateEnd;
        }
        if (!is_null($productGroup)) {
            $this->productGroup = $productGroup;
        }
    }

    public static function create(string $dateStart = '', string $dateEnd = '', array $productGroup = []): self {
        return new self($dateStart, $dateEnd, $productGroup);
    }

    public function setStoreIds(array $storeIds): self {
        $this->storeIds = $storeIds;

        return $this;
    }

    public function setStoreType(string $storeType): self {
        $this->storeType = $storeType;

        return $this;
    }

    public function setCityId(int $cityId): self {
        $this->cityId = $cityId;

        return $this;
    }

    public function setDateStart(string $dateStart): self {
        $this->dateStart = $dateStart;

        return $this;
    }

    public function setDateEnd(string $dateEnd): self {
        $this->dateEnd = $dateEnd;

        return $this;
    }

    public function setProductGroup(array $productGroup): self {
        $this->productGroup = $productGroup;

        return $this;
    }

    public function setOrderNum(?string $orderNum): self {
        $this->orderNum = $orderNum;

        return $this;
    }
}