<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-08-22 15:45:57
 */
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Preferential;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class GiftCard
 */
class GiftCard {
    private static string $serviceName = "AppointmentPlatform";

    private static string $className = "Preferential\\GiftCard";

    /**
     * 获取用户礼品卡列表
     * @return  array
    */
    public static function ownList (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Preferential\OwnListCmd $ownListCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->ownList($ownListCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\OwnGiftCardInfoDTO[]"
        );
    }
    /**
     * 礼品卡列表
     * @return  array
    */
    public static function getList (int $page = 1, int $pageSize = 10) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getList(["page" => $page, "pageSize" => $pageSize]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\GiftCardSeriesDTO[]"
        );
    }
    /**
     * 获取礼品卡主题信息
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\GiftCardTopicDTO
    */
    public static function getTopicList (int $topicId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getTopicList(["topicId" => $topicId]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\GiftCardTopicDTO"
        );
    }
    /**
     * 充值礼品码
     * @return  bool
    */
    public static function charge (string $giftCardCode) {
        return RpcClass::getClass(self::$serviceName, self::$className)->charge(["giftCardCode" => $giftCardCode]);
    }
    /**
     * 用户购买礼品卡
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\GiftCardCreateOrderDTO
    */
    public static function createOrder (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Preferential\CreateGiftCardOrderCmd $createGiftCardOrderCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->createOrder($createGiftCardOrderCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\GiftCardCreateOrderDTO"
        );
    }
    /**
     * 获取单个礼品卡订单详情
     * @return  array
    */
    public static function orderDetail (string $orderNum) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->orderDetail(["orderNum" => $orderNum]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\GiftCardOrderInfoDTO[]"
        );
    }
    /**
     * 礼品卡赠送
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\GiveDTO
    */
    public static function give (int $giftCardId, string $title, string $words) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->give(["giftCardId" => $giftCardId, "title" => $title, "words" => $words]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\GiveDTO"
        );
    }
    /**
     * 获取赠送详情
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\GiveDetailDTO
    */
    public static function giveDetail (string $code) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->giveDetail(["code" => $code]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\GiveDetailDTO"
        );
    }
    /**
     * 确认推送
     * @return  bool
    */
    public static function confirmGive (string $code, string $title, string $words) {
        return RpcClass::getClass(self::$serviceName, self::$className)->confirmGive(["code" => $code, "title" => $title, "words" => $words]);
    }
    /**
     * 接受赠送
     * @return  bool
    */
    public static function receiveGive (string $code) {
        return RpcClass::getClass(self::$serviceName, self::$className)->receiveGive(["code" => $code]);
    }
    /**
     * 取消推送
     * @return  bool
    */
    public static function cancelGive (int $giftCardId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->cancelGive(["giftCardId" => $giftCardId]);
    }
    /**
     * 获取礼品卡面值配置
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\FaceValueConfigDTO
    */
    public static function getGiftCardFaceValueConfig () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getGiftCardFaceValueConfig(),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\FaceValueConfigDTO"
        );
    }
    /**
     * 获取用户礼品卡列表-v1版本
     * @return  array
    */
    public static function ownListV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Preferential\OwnListCmd $ownListCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->ownListV1($ownListCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\OwnGiftCardInfoDTO[]"
        );
    }
    /**
     * 礼品卡列表-v1版本
     * @return  array
    */
    public static function getListV1 (int $page = 1, int $pageSize = 10) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getListV1(["page" => $page, "pageSize" => $pageSize]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\GiftCardSeriesDTO[]"
        );
    }
    /**
     * 获取礼品卡主题信息-v1版本
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\GiftCardTopicDTO
    */
    public static function getTopicListV1 (int $topicId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getTopicListV1(["topicId" => $topicId]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\GiftCardTopicDTO"
        );
    }
    /**
     * 充值礼品码-v1版本
     * @return  bool
    */
    public static function chargeV1 (string $giftCardCode) {
        return RpcClass::getClass(self::$serviceName, self::$className)->chargeV1(["giftCardCode" => $giftCardCode]);
    }
    /**
     * 用户购买礼品卡-v1版本
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\GiftCardCreateOrderDTO
    */
    public static function createOrderV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\Preferential\CreateGiftCardOrderCmd $createGiftCardOrderCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->createOrderV1($createGiftCardOrderCmd),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\GiftCardCreateOrderDTO"
        );
    }
    /**
     * 获取单个礼品卡订单详情-v1版本
     * @return  array
    */
    public static function orderDetailV1 (string $orderNum) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->orderDetailV1(["orderNum" => $orderNum]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\GiftCardOrderInfoDTO[]"
        );
    }
    /**
     * 礼品卡赠送-v1版本
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\GiveDTO
    */
    public static function giveV1 (int $giftCardId, string $title, string $words) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->giveV1(["giftCardId" => $giftCardId, "title" => $title, "words" => $words]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\GiveDTO"
        );
    }
    /**
     * 获取赠送详情-v1版本
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\GiveDetailDTO
    */
    public static function giveDetailV1 (string $code) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->giveDetailV1(["code" => $code]),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\GiveDetailDTO"
        );
    }
    /**
     * 确认推送-v1版本
     * @return  bool
    */
    public static function confirmGiveV1 (string $code, string $title, string $words) {
        return RpcClass::getClass(self::$serviceName, self::$className)->confirmGiveV1(["code" => $code, "title" => $title, "words" => $words]);
    }
    /**
     * 接受赠送-v1版本
     * @return  bool
    */
    public static function receiveGiveV1 (string $code) {
        return RpcClass::getClass(self::$serviceName, self::$className)->receiveGiveV1(["code" => $code]);
    }
    /**
     * 取消推送-v1版本
     * @return  bool
    */
    public static function cancelGiveV1 (int $giftCardId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->cancelGiveV1(["giftCardId" => $giftCardId]);
    }
    /**
     * 获取礼品卡面值配置
     * @return  \Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\FaceValueConfigDTO
    */
    public static function getGiftCardFaceValueConfigV1 () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getGiftCardFaceValueConfigV1(),
            "\Mainto\Bridge\Structs\AppointmentPlatform\DTO\Preferential\FaceValueConfigDTO"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}