<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-08-22 11:53:26
 */
namespace Mainto\Bridge\Structs\AppointmentPlatform\DTO\UserMember;

class UserMemberInfoDTO {
    /**
     * @var  float
     * 消费总金额
     * validation: 
     */
    public float $consumeTotal = 0;
    /**
     * @var  float
     * 用户基础纪念值
     * validation: 
     */
    public float $userExp = 0;
    /**
     * @var  float
     * 用户累计纪念值
     * validation: 
     */
    public float $userIntegral = 0;
    /**
     * @var  string
     * 用户等级
     * validation: 
     */
    public string $userLevel;
    /**
     * @var  int
     * 用户消费次数
     * validation: 
     */
    public int $consumeNum = 0;
    /**
     * @var  string
     * 会员复审日期
     * validation: 
     */
    public string $reviewTime = "";
    /**
     * @var  string
     * 上次购买时间
     * validation: 
     */
    public string $lastBuyTime = "";
    /**
     * @var  string
     * 成为会员的时间
     * validation: 
     */
    public string $joinMemberTime = "";
    /**
     * @var  int
     * 接受推送
     * validation: 
     */
    public int $enablePush = 0;
    /**
     * @var  int
     * 下一等级需要的分数, 如果为0，表示已经没有下一等级了，通常是用户已经v4的情况
     * validation: 
     */
    public int $nextScore = 0;
    /**
     * @var  int
     * 下一等级需要的消费次数, 如果为0，表示已经没有下一等级了，通常是用户已经v4的情况
     * validation: 
     */
    public int $nextConsumeTimes;
    /**
     * @var  string
     * 里程碑状态 none 无领取，waiting 有待领取
     * validation: 
     */
    public string $milestoneStatus;
    /**
     * @var  bool
     * 是否是大学生
     * validation: 
     */
    public bool $isCollegeStudent;
    /**
     * @var  string
     * 情侣会员状态
     * validation: 
     */
    public string $coupleMemberStatus;

    public function __construct (string $userLevel = '', int $nextConsumeTimes = 0, string $milestoneStatus = '', bool $isCollegeStudent = false, string $coupleMemberStatus = '') {
        if (!is_null($userLevel)) {
            $this->userLevel = $userLevel;
        }
        if (!is_null($nextConsumeTimes)) {
            $this->nextConsumeTimes = $nextConsumeTimes;
        }
        if (!is_null($milestoneStatus)) {
            $this->milestoneStatus = $milestoneStatus;
        }
        if (!is_null($isCollegeStudent)) {
            $this->isCollegeStudent = $isCollegeStudent;
        }
        if (!is_null($coupleMemberStatus)) {
            $this->coupleMemberStatus = $coupleMemberStatus;
        }
    }

    public static function create(string $userLevel = '', int $nextConsumeTimes = 0, string $milestoneStatus = '', bool $isCollegeStudent = false, string $coupleMemberStatus = ''): self {
        return new self($userLevel, $nextConsumeTimes, $milestoneStatus, $isCollegeStudent, $coupleMemberStatus);
    }

    public function setConsumeTotal(float $consumeTotal): self {
        $this->consumeTotal = $consumeTotal;

        return $this;
    }

    public function setUserExp(float $userExp): self {
        $this->userExp = $userExp;

        return $this;
    }

    public function setUserIntegral(float $userIntegral): self {
        $this->userIntegral = $userIntegral;

        return $this;
    }

    public function setUserLevel(string $userLevel): self {
        $this->userLevel = $userLevel;

        return $this;
    }

    public function setConsumeNum(int $consumeNum): self {
        $this->consumeNum = $consumeNum;

        return $this;
    }

    public function setReviewTime(string $reviewTime): self {
        $this->reviewTime = $reviewTime;

        return $this;
    }

    public function setLastBuyTime(string $lastBuyTime): self {
        $this->lastBuyTime = $lastBuyTime;

        return $this;
    }

    public function setJoinMemberTime(string $joinMemberTime): self {
        $this->joinMemberTime = $joinMemberTime;

        return $this;
    }

    public function setEnablePush(int $enablePush): self {
        $this->enablePush = $enablePush;

        return $this;
    }

    public function setNextScore(int $nextScore): self {
        $this->nextScore = $nextScore;

        return $this;
    }

    public function setNextConsumeTimes(int $nextConsumeTimes): self {
        $this->nextConsumeTimes = $nextConsumeTimes;

        return $this;
    }

    public function setMilestoneStatus(string $milestoneStatus): self {
        $this->milestoneStatus = $milestoneStatus;

        return $this;
    }

    public function setIsCollegeStudent(bool $isCollegeStudent): self {
        $this->isCollegeStudent = $isCollegeStudent;

        return $this;
    }

    public function setCoupleMemberStatus(string $coupleMemberStatus): self {
        $this->coupleMemberStatus = $coupleMemberStatus;

        return $this;
    }
}